/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerBuildingInventory
extends Container {
    private final IItemHandler buildingInventory;
    private final TileEntityColonyBuilding tileEntityColonyBuilding;
    private final int inventorySize;

    public static ContainerBuildingInventory fromPacketBuffer(int windowId, PlayerInventory inv, PacketBuffer packetBuffer) {
        int colonyId = packetBuffer.func_150792_a();
        BlockPos tePos = packetBuffer.func_179259_c();
        return new ContainerBuildingInventory(windowId, inv, colonyId, tePos);
    }

    public ContainerBuildingInventory(int windowId, final PlayerInventory inv, final int colonyId, final BlockPos pos) {
        super(ModContainers.buildingInv, windowId);
        int i;
        this.tileEntityColonyBuilding = (TileEntityColonyBuilding)inv.field_70458_d.field_70170_p.func_175625_s(pos);
        this.buildingInventory = this.tileEntityColonyBuilding.getInventory();
        int size = this.buildingInventory.getSlots();
        this.inventorySize = size / 9;
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.func_75146_a((Slot)new SlotItemHandler(this.buildingInventory, index, 8 + k * 18, 18 + j * 18){

                    public void func_75215_d(ItemStack stack) {
                        IColony colony;
                        IBuilding building;
                        super.func_75215_d(stack);
                        if (!inv.field_70458_d.field_70170_p.field_72995_K && !ItemStackUtils.isEmpty(stack).booleanValue() && (building = (colony = IColonyManager.getInstance().getColonyByWorld(colonyId, inv.field_70458_d.field_70170_p)).getBuildingManager().getBuilding(pos)) != null) {
                            building.overruleNextOpenRequestWithStack(stack);
                        }
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.func_75211_c().func_77946_l();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.func_75135_a(stackCopy, maxIndex, this.field_75151_b.size(), true) : !this.func_75135_a(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.func_75215_d(ItemStackUtils.EMPTY);
        } else {
            slot.func_75215_d(stackCopy);
        }
        return stackCopy;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return this.tileEntityColonyBuilding.isUsableByPlayer(playerIn);
    }

    public int getSize() {
        return this.inventorySize;
    }
}

