/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting.registry;

import com.minecolonies.api.crafting.AbstractRecipeType;
import com.minecolonies.api.crafting.IRecipeStorage;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public final class RecipeTypeEntry
extends ForgeRegistryEntry<RecipeTypeEntry> {
    private final Function<IRecipeStorage, AbstractRecipeType<IRecipeStorage>> recipeTypeProducer;

    public Function<IRecipeStorage, AbstractRecipeType<IRecipeStorage>> getHandlerProducer() {
        return this.recipeTypeProducer;
    }

    private RecipeTypeEntry(Function<IRecipeStorage, AbstractRecipeType<IRecipeStorage>> recipeTypeProducer) {
        this.recipeTypeProducer = recipeTypeProducer;
    }

    public static final class Builder {
        private Function<IRecipeStorage, AbstractRecipeType<IRecipeStorage>> recipeTypeProducer;
        private ResourceLocation registryName;

        public Builder setRecipeTypeProducer(Function<IRecipeStorage, AbstractRecipeType<IRecipeStorage>> recipeTypeProducer) {
            this.recipeTypeProducer = recipeTypeProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public RecipeTypeEntry createRecipeTypeEntry() {
            Validate.notNull(this.recipeTypeProducer);
            Validate.notNull((Object)this.registryName);
            return (RecipeTypeEntry)new RecipeTypeEntry(this.recipeTypeProducer).setRegistryName(this.registryName);
        }
    }
}

