/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.permissions;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPermissions {
    public static final int OWNER_RANK_ID = 0;
    public static final int OFFICER_RANK_ID = 1;
    public static final int FRIEND_RANK_ID = 2;
    public static final int NEUTRAL_RANK_ID = 3;
    public static final int HOSTILE_RANK_ID = 4;

    public boolean hasPermission(Rank var1, @NotNull Action var2);

    public Set<Player> getPlayersByRank(Rank var1);

    public Set<Player> getPlayersByRank(@NotNull Set<Rank> var1);

    public Map<Integer, Rank> getRanks();

    public Rank getRank(int var1);

    public Rank getRankOwner();

    public Rank getRankOfficer();

    public Rank getRankHostile();

    public Rank getRankNeutral();

    public Rank getRankFriend();

    public boolean hasPermission(PlayerEntity var1, Action var2);

    public boolean addPlayer(@NotNull String var1, Rank var2, World var3);

    public boolean addPlayer(@NotNull UUID var1, String var2, Rank var3);

    @Nullable
    public String getOwnerName();

    public boolean isSubscriber(@NotNull PlayerEntity var1);

    public boolean isColonyMember(PlayerEntity var1);

    public boolean alterPermission(Rank var1, Rank var2, @NotNull Action var3, boolean var4);

    @Nullable
    public Map.Entry<UUID, Player> getOwnerEntry();

    public boolean setOwner(PlayerEntity var1);

    public boolean canAlterPermission(Rank var1, Rank var2, @NotNull Action var3);

    public void setOwnerAbandoned();

    @NotNull
    public UUID getOwner();

    @NotNull
    public Map<UUID, Player> getPlayers();

    public boolean setPlayerRank(UUID var1, Rank var2, World var3);

    public boolean addPlayer(@NotNull GameProfile var1, Rank var2);

    @NotNull
    public Rank getRank(UUID var1);

    public Rank getRank(PlayerEntity var1);

    public void restoreOwnerIfNull();

    public boolean setPermission(Rank var1, Action var2, boolean var3);

    public boolean removePlayer(UUID var1);

    public void addRank(String var1);

    public void removeRank(Rank var1);

    public Set<Player> getFilteredPlayers(Predicate<Rank> var1);
}

