/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.guardtype;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.Skill;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GuardType
extends ForgeRegistryEntry<GuardType> {
    private final Supplier<JobEntry> jobEntry;
    private final String jobTranslationKey;
    private final String buttonTranslationKey;
    private final Skill primarySkill;
    private final Skill secondarySkill;
    private final String workerSoundName;
    private final Class<IJob<?>> clazz;

    public GuardType(Supplier<JobEntry> jobEntry, String jobTranslationKey, String buttonTranslationKey, Skill primarySkill, Skill secondarySkill, String workerSoundName, Class<IJob<?>> clazz) {
        this.jobEntry = jobEntry;
        this.jobTranslationKey = jobTranslationKey;
        this.buttonTranslationKey = buttonTranslationKey;
        this.primarySkill = primarySkill;
        this.secondarySkill = secondarySkill;
        this.workerSoundName = workerSoundName;
        this.clazz = clazz;
    }

    public Supplier<JobEntry> getJobEntry() {
        return this.jobEntry;
    }

    public String getJobTranslationKey() {
        return this.jobTranslationKey;
    }

    public String getButtonTranslationKey() {
        return this.buttonTranslationKey;
    }

    public Skill getPrimarySkill() {
        return this.primarySkill;
    }

    public Skill getSecondarySkill() {
        return this.secondarySkill;
    }

    public String getWorkerSoundName() {
        return this.workerSoundName;
    }

    public boolean isInstance(IJob<?> job) {
        return this.clazz.isInstance(job);
    }

    public static class Builder {
        private Supplier<JobEntry> jobEntry;
        private String jobTranslationKey;
        private String buttonTranslationKey;
        private Skill primarySkill;
        private Skill secondarySkill;
        private String workerSoundName;
        private ResourceLocation registryName;
        private Class<IJob<?>> clazz;

        public Builder setJobEntry(Supplier<JobEntry> jobEntry) {
            this.jobEntry = jobEntry;
            return this;
        }

        public Builder setJobTranslationKey(String jobTranslationKey) {
            this.jobTranslationKey = jobTranslationKey;
            return this;
        }

        public Builder setButtonTranslationKey(String buttonTranslationKey) {
            this.buttonTranslationKey = buttonTranslationKey;
            return this;
        }

        public Builder setPrimarySkill(Skill primarySkill) {
            this.primarySkill = primarySkill;
            return this;
        }

        public Builder setSecondarySkill(Skill secondarySkill) {
            this.secondarySkill = secondarySkill;
            return this;
        }

        public Builder setWorkerSoundName(String workerSoundName) {
            this.workerSoundName = workerSoundName;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public Builder setClazz(Class clazz) {
            this.clazz = clazz;
            return this;
        }

        public GuardType createGuardType() {
            return (GuardType)new GuardType(this.jobEntry, this.jobTranslationKey, this.buttonTranslationKey, this.primarySkill, this.secondarySkill, this.workerSoundName, this.clazz).setRegistryName(this.registryName);
        }
    }
}

