/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.IResearchManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColony {
    public void onWorldLoad(@NotNull World var1);

    public void onWorldUnload(@NotNull World var1);

    public void onServerTick(@NotNull TickEvent.ServerTickEvent var1);

    @NotNull
    public IWorkManager getWorkManager();

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent var1);

    public BlockPos getCenter();

    public String getName();

    public void setName(String var1);

    public IPermissions getPermissions();

    public boolean isCoordInColony(World var1, BlockPos var2);

    public long getDistanceSquared(BlockPos var1);

    public boolean hasTownHall();

    public int getID();

    public boolean hasWarehouse();

    public boolean hasBuilding(String var1, int var2, boolean var3);

    default public String getTeamName() {
        String dim = this.getDimension().func_240901_a_().func_110623_a();
        return "c_" + (dim.length() > 10 ? Integer.valueOf(dim.hashCode()) : dim) + "_" + this.getID();
    }

    public ListNBT getColonyFlag();

    public boolean isDay();

    public ScorePlayerTeam getTeam();

    public int getLastContactInHours();

    public World getWorld();

    @NotNull
    public IRequestManager getRequestManager();

    public void markDirty();

    public boolean canBeAutoDeleted();

    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos var1);

    public void removeVisitingPlayer(PlayerEntity var1);

    @NotNull
    public List<PlayerEntity> getMessagePlayerEntities();

    @NotNull
    default public List<BlockPos> getWayPoints(@NotNull BlockPos position, @NotNull BlockPos target) {
        ArrayList<BlockPos> tempWayPoints = new ArrayList<BlockPos>();
        tempWayPoints.addAll(this.getWayPoints().keySet());
        tempWayPoints.addAll(this.getBuildingManager().getBuildings().keySet());
        double maxX = Math.max(position.func_177958_n(), target.func_177958_n());
        double maxZ = Math.max(position.func_177952_p(), target.func_177952_p());
        double minX = Math.min(position.func_177958_n(), target.func_177958_n());
        double minZ = Math.min(position.func_177952_p(), target.func_177952_p());
        Iterator iterator = tempWayPoints.iterator();
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            int x = p.func_177958_n();
            int z = p.func_177952_p();
            if (!((double)x < minX || (double)x > maxX || (double)z < minZ) && !((double)z > maxZ)) continue;
            iterator.remove();
        }
        return tempWayPoints;
    }

    public double getOverallHappiness();

    public Map<BlockPos, BlockState> getWayPoints();

    public String getStyle();

    public void setStyle(String var1);

    public IRegisteredStructureManager getBuildingManager();

    public ICitizenManager getCitizenManager();

    public IGraveManager getGraveManager();

    public IVisitorManager getVisitorManager();

    public IRaiderManager getRaiderManager();

    public IEventManager getEventManager();

    public IReproductionManager getReproductionManager();

    public IEventDescriptionManager getEventDescriptionManager();

    public IColonyPackageManager getPackageManager();

    public IProgressManager getProgressManager();

    public void addVisitingPlayer(PlayerEntity var1);

    public RegistryKey<World> getDimension();

    public boolean isRemote();

    public IResearchManager getResearchManager();

    public void usedMercenaries();

    public long getMercenaryUseTime();

    public CompoundNBT getColonyTag();

    public boolean isColonyUnderAttack();

    public boolean isValidAttackingPlayer(PlayerEntity var1);

    public boolean isValidAttackingGuard(AbstractEntityCitizen var1);

    public void setColonyColor(TextFormatting var1);

    public void setColonyFlag(ListNBT var1);

    public void setManualHousing(boolean var1);

    public void addWayPoint(BlockPos var1, BlockState var2);

    public void addGuardToAttackers(AbstractEntityCitizen var1, PlayerEntity var2);

    public void addFreePosition(BlockPos var1);

    public void addFreeBlock(Block var1);

    public void removeFreePosition(BlockPos var1);

    public void removeFreeBlock(Block var1);

    public void setCanBeAutoDeleted(boolean var1);

    public void setManualHiring(boolean var1);

    public CompoundNBT write(CompoundNBT var1);

    public void read(CompoundNBT var1);

    public void setMoveIn(boolean var1);

    @NotNull
    public List<PlayerEntity> getImportantMessageEntityPlayers();

    public boolean isManualHiring();

    public boolean isManualHousing();

    public boolean canMoveIn();

    public boolean useAdditionalChildTime(int var1);

    public void updateHasChilds();

    public void addLoadedChunk(long var1, Chunk var3);

    public void removeLoadedChunk(long var1);

    public int getLoadedChunkCount();

    public ColonyState getState();

    public boolean isActive();

    public Set<Long> getTicketedChunks();

    public void setTextureStyle(String var1);

    public String getTextureStyleId();
}

