/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements.building_add_recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.IRecipeStorage;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BuildingAddRecipeCriterionInstance
extends CriterionInstance {
    private ItemPredicate[] outputItemPredicates;
    private int craftingSize = -1;

    public BuildingAddRecipeCriterionInstance() {
        super(new ResourceLocation("minecolonies", "building_add_recipe"), EntityPredicate.AndPredicate.field_234582_a_);
    }

    public BuildingAddRecipeCriterionInstance(ItemPredicate[] outputItemPredicates) {
        super(new ResourceLocation("minecolonies", "building_add_recipe"), EntityPredicate.AndPredicate.field_234582_a_);
        this.outputItemPredicates = outputItemPredicates;
    }

    public BuildingAddRecipeCriterionInstance(ItemPredicate[] outputItemPredicates, int craftingSize) {
        super(new ResourceLocation("minecolonies", "building_add_recipe"), EntityPredicate.AndPredicate.field_234582_a_);
        this.outputItemPredicates = outputItemPredicates;
        this.craftingSize = craftingSize;
    }

    public boolean test(IRecipeStorage recipeStorage) {
        if (this.outputItemPredicates != null) {
            boolean outputMatches = false;
            for (ItemPredicate itemPredicate : this.outputItemPredicates) {
                if (!itemPredicate.func_192493_a(recipeStorage.getPrimaryOutput())) continue;
                outputMatches = true;
                break;
            }
            if (this.craftingSize != -1) {
                return outputMatches && this.craftingSize == recipeStorage.getGridSize();
            }
            return outputMatches;
        }
        return true;
    }

    @NotNull
    public static BuildingAddRecipeCriterionInstance deserializeFromJson(@NotNull JsonObject jsonObject, @NotNull ConditionArrayParser conditions) {
        if (jsonObject.has("items")) {
            ItemPredicate[] outputItemPredicates = ItemPredicate.func_192494_b((JsonElement)jsonObject.get("items"));
            if (jsonObject.has("crafting_size")) {
                int craftingSize = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"crafting_size");
                return new BuildingAddRecipeCriterionInstance(outputItemPredicates, craftingSize);
            }
            return new BuildingAddRecipeCriterionInstance(outputItemPredicates);
        }
        return new BuildingAddRecipeCriterionInstance();
    }

    @NotNull
    public JsonObject func_230240_a_(@NotNull ConditionArraySerializer serializer) {
        JsonObject json = super.func_230240_a_(serializer);
        if (this.outputItemPredicates != null && this.outputItemPredicates.length > 0) {
            JsonArray outputItemPredicates = new JsonArray();
            for (ItemPredicate predicate : this.outputItemPredicates) {
                outputItemPredicates.add(predicate.func_200319_a());
            }
            json.add("items", (JsonElement)outputItemPredicates);
        }
        if (this.craftingSize >= 0) {
            json.addProperty("crafting_size", (Number)this.craftingSize);
        }
        return json;
    }
}

