/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.compose.planner.Tools;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ToolSelectionScreen
extends Screen {
    protected List<Tools> tools;
    protected Consumer<Tools> callback;
    public boolean field_230699_a_;
    private float yOffset;
    protected int selection;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<Tools> tools, Consumer<Tools> callback) {
        super((ITextComponent)new StringTextComponent("Tool Selection"));
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.tools = tools;
        this.callback = callback;
        this.field_230699_a_ = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.w = tools.size() * 50 + 30;
        this.h = 30;
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(MatrixStack ms, float partialTicks) {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        FontRenderer font = this.field_230706_i_.field_71466_p;
        int x = (mainWindow.func_198107_o() - this.w) / 2 + 15;
        int y = 15;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)(this.field_230699_a_ ? 100.0f : 0.0f));
        ScreenResources gray = ScreenResources.GRAY;
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.field_230699_a_ ? 0.875f : 0.5f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        float toolTipAlpha = this.yOffset / 10.0f;
        ToolSelectionScreen.func_238463_a_((MatrixStack)ms, (int)(x - 15), (int)y, (float)gray.startX, (float)gray.startY, (int)this.w, (int)this.h, (int)gray.width, (int)gray.height);
        List<String> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
            RenderSystem.color4f((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            ToolSelectionScreen.func_238463_a_((MatrixStack)ms, (int)(x - 15), (int)(y + 30), (float)gray.startX, (float)gray.startY, (int)this.w, (int)(this.h + 22), (int)gray.width, (int)gray.height);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                font.func_238421_b_(ms, toolTip.get(0), (float)(x - 10), (float)(y + 35), 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                font.func_238421_b_(ms, toolTip.get(1), (float)(x - 10), (float)(y + 47), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                font.func_238421_b_(ms, toolTip.get(2), (float)(x - 10), (float)(y + 57), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                font.func_238421_b_(ms, toolTip.get(3), (float)(x - 10), (float)(y + 69), 0xCCCCDD + stringAlphaComponent);
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String translationKey = MightyClient.TOOL_MENU.func_238171_j_().getString().toUpperCase();
        int width = this.field_230706_i_.func_228018_at_().func_198107_o();
        if (!this.field_230699_a_) {
            ToolSelectionScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230706_i_.field_71466_p, (String)("Hold [" + translationKey + "] to focus"), (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
        } else {
            ToolSelectionScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"[SCROLL] to Cycle", (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            RenderSystem.pushMatrix();
            float f = alpha = this.field_230699_a_ ? 1.0f : 0.2f;
            if (i == this.selection) {
                RenderSystem.translatef((float)0.0f, (float)-10.0f, (float)0.0f);
                ToolSelectionScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.tools.get(i).getDisplayName(), (int)(x + i * 50 + 24), (int)(y + 28), (int)0xCCDDFF);
                alpha = 1.0f;
            }
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().draw(ms, (AbstractGui)this, x + i * 50 + 16, y + 12);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().draw(ms, (AbstractGui)this, x + i * 50 + 16, y + 11);
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }

    public void update() {
        this.yOffset = this.field_230699_a_ ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(MatrixStack ms, float partialTicks) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        this.draw(ms, partialTicks);
    }

    public void func_231175_as__() {
        this.callback.accept(this.tools.get(this.selection));
    }
}

