/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase.export;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.AllSpecialTextures;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import com.simibubi.mightyarchitect.foundation.utility.BuildingHelper;
import com.simibubi.mightyarchitect.foundation.utility.outliner.AABBOutline;
import com.simibubi.mightyarchitect.foundation.utility.outliner.BlockClusterOutline;
import com.simibubi.mightyarchitect.foundation.utility.outliner.Outline;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class PhaseEditTheme
extends PhaseBase {
    public static Cuboid selectedDesign;
    public static Outline effectiveSelectedDesign;
    public static int effectiveHeight;
    public String frontText;
    public String rightText;
    public String backText;
    public String leftText;
    private DesignType lastType;
    static final Object effectiveDesignKey;
    static final Object textKey1;
    static final Object textKey2;
    static final Object textKey3;
    static final Object textKey4;

    @Override
    public void whenEntered() {
        selectedDesign = null;
        effectiveSelectedDesign = null;
        this.frontText = null;
        this.rightText = null;
        this.leftText = null;
        this.backText = null;
        this.lastType = null;
        effectiveHeight = 0;
    }

    @Override
    public void update() {
        this.tickOutlines();
        if (this.lastType == DesignExporter.type) {
            return;
        }
        this.frontText = null;
        this.rightText = null;
        this.leftText = null;
        this.backText = null;
        this.lastType = DesignExporter.type;
        switch (this.lastType) {
            case CORNER: {
                this.frontText = "Facade";
                this.rightText = "Side Facade";
                break;
            }
            case FACADE: 
            case WALL: {
                this.frontText = "Facade";
                this.backText = "Back";
                break;
            }
            case FLAT_ROOF: {
                this.frontText = "Front";
                this.rightText = "Back";
                this.backText = "Back";
                this.leftText = "Front";
                break;
            }
            case ROOF: {
                this.frontText = "Facade";
                this.leftText = "Side";
                this.rightText = "Side";
                this.backText = "Back";
                break;
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                break;
            }
        }
    }

    private void tickOutlines() {
        if (selectedDesign == null) {
            return;
        }
        MightyClient.outliner.chaseAABB("editThemeSelection", selectedDesign.toAABB());
        if (effectiveSelectedDesign != null) {
            MightyClient.outliner.show(effectiveDesignKey, effectiveSelectedDesign).withFaceTexture(AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f);
        }
        Cuboid selection = selectedDesign;
        float hw = (float)selection.width / 2.0f;
        float hl = (float)selection.length / 2.0f;
        this.chaseText(textKey1, (float)selection.x + hw, (float)selection.y + 0.5f, selection.z - 1, this.backText);
        this.chaseText(textKey2, (float)selection.x + hw, (float)selection.y + 0.5f, selection.z + selection.length + 1, this.frontText);
        this.chaseText(textKey3, selection.x + selection.width + 1, (float)selection.y + 0.5f, (float)selection.z + hl, this.rightText);
        this.chaseText(textKey4, selection.x - 1, (float)selection.y + 0.5f, (float)selection.z + hl, this.leftText);
    }

    private void chaseText(Object key, float x, float y, float z, String text) {
        MightyClient.outliner.chaseText(key, new Vector3d((double)x, (double)y, (double)z), text).disableNormals().colored(0xFFFFFF);
    }

    @Override
    public void whenExited() {
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Right click the origin marker of your designs to scan them.", (Object)"Don't forget to pick the correct traits (type, layer, size) for the next design!");
    }

    public static void setVisualization(Cuboid bounds) {
        MightyClient.outliner.remove(effectiveDesignKey);
        selectedDesign = bounds;
        effectiveSelectedDesign = null;
        if (selectedDesign == null) {
            return;
        }
        Function<Cuboid, Outline> outlineFunc = c -> new AABBOutline(c.toAABB());
        switch (DesignExporter.type) {
            case CORNER: {
                effectiveSelectedDesign = outlineFunc.apply(new Cuboid(selectedDesign.getOrigin(), 1, effectiveHeight, 1));
                break;
            }
            case FACADE: 
            case WALL: {
                effectiveSelectedDesign = outlineFunc.apply(new Cuboid(selectedDesign.getOrigin(), PhaseEditTheme.selectedDesign.width, effectiveHeight, 1));
                break;
            }
            case FLAT_ROOF: {
                int margin = DesignExporter.designParameter;
                effectiveSelectedDesign = outlineFunc.apply(new Cuboid(selectedDesign.getOrigin().func_177965_g(margin), selectedDesign.getSize().func_177982_a(-margin, 0, -margin)));
                break;
            }
            case ROOF: {
                int span = DesignExporter.designParameter;
                int margin = (PhaseEditTheme.selectedDesign.width - span) / 2;
                effectiveSelectedDesign = outlineFunc.apply(new Cuboid(selectedDesign.getOrigin().func_177982_a(margin, 0, 0), PhaseEditTheme.selectedDesign.width - 2 * margin, PhaseEditTheme.selectedDesign.height, 3));
                break;
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                int radius = DesignExporter.designParameter;
                int margin = (PhaseEditTheme.selectedDesign.width - (radius * 2 + 1)) / 2;
                BlockPos center = selectedDesign.getCenter().func_177979_c(PhaseEditTheme.selectedDesign.height / 2);
                ArrayList<BlockPos> cylinderSet = new ArrayList<BlockPos>();
                int i = 0;
                while (i < effectiveHeight) {
                    int offset = i++;
                    BuildingHelper.getCircle(center, radius).forEach(pos -> cylinderSet.add(pos.func_177981_b(offset)));
                }
                effectiveSelectedDesign = new BlockClusterOutline(cylinderSet);
                break;
            }
        }
    }

    public static boolean isVisualizing() {
        return selectedDesign != null;
    }

    public static void resetVisualization() {
        selectedDesign = null;
        effectiveSelectedDesign = null;
        effectiveHeight = 0;
    }

    @Override
    public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
    }

    static {
        effectiveDesignKey = new Object();
        textKey1 = new Object();
        textKey2 = new Object();
        textKey3 = new Object();
        textKey4 = new Object();
    }
}

