/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.palette;

import com.simibubi.mightyarchitect.control.palette.BlockOrientation;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;

public class PaletteDefinition {
    private Map<Palette, BlockState> definition = new HashMap<Palette, BlockState>();
    private String name;
    private BlockState clear;
    private static PaletteDefinition defaultPalette;

    public static PaletteDefinition defaultPalette() {
        if (defaultPalette == null) {
            defaultPalette = new PaletteDefinition("Standard Palette");
            defaultPalette.put(Palette.HEAVY_PRIMARY, Blocks.field_196657_h).put(Palette.HEAVY_SECONDARY, Blocks.field_150347_e).put(Palette.HEAVY_WINDOW, Blocks.field_196776_gO).put(Palette.HEAVY_POST, Blocks.field_196723_eg).put(Palette.INNER_DETAIL, Blocks.field_196629_R).put(Palette.INNER_PRIMARY, Blocks.field_196664_o).put(Palette.INNER_SECONDARY, Blocks.field_196672_s).put(Palette.OUTER_FLAT, (BlockState)((BlockState)Blocks.field_196636_cW.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)Boolean.valueOf(true))).put(Palette.OUTER_SLAB, Blocks.field_196646_bz).put(Palette.OUTER_THICK, Blocks.field_150463_bK).put(Palette.OUTER_THIN, Blocks.field_180408_aP).put(Palette.ROOF_PRIMARY, Blocks.field_196650_c).put(Palette.FLOOR, Blocks.field_196662_n).put(Palette.ROOF_DETAIL, Blocks.field_196584_bK).put(Palette.CLEAR, Blocks.field_180401_cv).put(Palette.ROOF_SLAB, Blocks.field_196571_bA).put(Palette.WINDOW, Blocks.field_150410_aZ);
        }
        return defaultPalette;
    }

    public PaletteDefinition clone() {
        PaletteDefinition clone = new PaletteDefinition(this.name);
        clone.clear = PaletteDefinition.defaultPalette().clear();
        clone.definition = new HashMap<Palette, BlockState>(PaletteDefinition.defaultPalette().getDefinition());
        this.definition.forEach((key, value) -> clone.definition.put((Palette)((Object)key), (BlockState)value));
        clone.definition.put(Palette.CLEAR, Blocks.field_180401_cv.func_176223_P());
        return clone;
    }

    public PaletteDefinition(String name) {
        this.definition.put(Palette.CLEAR, Blocks.field_180401_cv.func_176223_P());
        this.name = name;
    }

    public PaletteDefinition put(Palette key, Block block) {
        return this.put(key, block.func_176223_P());
    }

    public PaletteDefinition put(Palette key, BlockState block) {
        if (block.func_177230_c() instanceof TrapDoorBlock) {
            block = (BlockState)block.func_206870_a((Property)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(true));
        }
        this.definition.put(key, block);
        return this;
    }

    public Map<Palette, BlockState> getDefinition() {
        return this.definition;
    }

    public BlockState clear() {
        if (this.clear == null) {
            this.clear = this.get(Palette.CLEAR);
        }
        return this.clear;
    }

    public BlockState get(Palette key) {
        BlockState iBlockState = this.get(key, BlockOrientation.NONE);
        if (iBlockState.func_177230_c() instanceof LeavesBlock) {
            iBlockState = (BlockState)iBlockState.func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
        }
        return iBlockState;
    }

    private BlockState get(Palette key, BlockOrientation orientation) {
        BlockState iBlockState = this.definition.get((Object)key);
        return iBlockState == null ? Blocks.field_150350_a.func_176223_P() : orientation.apply(iBlockState);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CompoundNBT writeToNBT(CompoundNBT compound) {
        compound = compound == null ? new CompoundNBT() : compound;
        CompoundNBT palette = new CompoundNBT();
        palette.func_74778_a("Name", this.getName());
        Palette[] values = Palette.values();
        for (int i = 0; i < values.length; ++i) {
            CompoundNBT state = NBTUtil.func_190009_a((BlockState)this.get(values[i]));
            palette.func_218657_a(values[i].name(), (INBT)state);
        }
        compound.func_218657_a("Palette", (INBT)palette);
        return compound;
    }

    public static PaletteDefinition fromNBT(CompoundNBT compound) {
        PaletteDefinition palette = PaletteDefinition.defaultPalette().clone();
        if (compound != null && compound.func_74764_b("Palette")) {
            CompoundNBT paletteTag = compound.func_74775_l("Palette");
            palette.name = paletteTag.func_74779_i("Name");
            for (Palette key : Palette.values()) {
                if (!paletteTag.func_74764_b(key.name())) continue;
                palette.put(key, NBTUtil.func_190008_d((CompoundNBT)paletteTag.func_74775_l(key.name())));
            }
        }
        palette.put(Palette.CLEAR, Blocks.field_180401_cv.func_176223_P());
        return palette;
    }

    public BlockState get(PaletteBlockInfo paletteInfo) {
        BlockState state = this.definition.get((Object)paletteInfo.palette);
        state = state == null ? Blocks.field_150350_a.func_176223_P() : paletteInfo.apply(state);
        Collection properties = state.func_235904_r_();
        for (Property property : properties) {
            Direction facing;
            if (!(property instanceof DirectionProperty) || (facing = (Direction)state.func_177229_b(property)).func_176740_k() == Direction.Axis.Y || (!paletteInfo.mirrorZ || facing.func_176740_k() == Direction.Axis.Z) && (!paletteInfo.mirrorX || facing.func_176740_k() == Direction.Axis.X)) continue;
            state = (BlockState)state.func_206870_a((Property)((DirectionProperty)property), (Comparable)facing.func_176734_d());
        }
        return state;
    }

    public String getDuplicates() {
        for (Palette key : this.definition.keySet()) {
            Palette keyIgnoreRotation;
            if (key == (keyIgnoreRotation = this.getKeyIgnoreRotation(this.definition.get((Object)key)))) continue;
            return key.getDisplayName() + " = " + keyIgnoreRotation.getDisplayName();
        }
        return "";
    }

    public boolean hasDuplicates() {
        for (Palette key : this.definition.keySet()) {
            if (key == this.getKeyIgnoreRotation(this.definition.get((Object)key))) continue;
            return true;
        }
        return false;
    }

    public Palette scan(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return null;
        }
        if (this.definition.containsValue(state)) {
            for (Palette key : this.definition.keySet()) {
                if (!this.definition.get((Object)key).equals(state)) continue;
                return key;
            }
        }
        Palette keyIgnoreRotation = this.getKeyIgnoreRotation(state);
        return keyIgnoreRotation;
    }

    protected Palette getKeyIgnoreRotation(BlockState state) {
        HashMap scanMap = new HashMap();
        this.definition.forEach((palette, block) -> scanMap.put(block.func_177230_c(), palette));
        if (scanMap.containsKey(state.func_177230_c())) {
            return (Palette)((Object)scanMap.get(state.func_177230_c()));
        }
        return null;
    }
}

