/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design.partials;

import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public class Wall
extends Design {
    public ExpandBehaviour expandBehaviour;

    @Override
    public Design fromNBT(CompoundNBT compound) {
        Wall wall = new Wall();
        wall.applyNBT(compound);
        wall.expandBehaviour = ExpandBehaviour.valueOf(compound.func_74779_i("ExpandBehaviour"));
        return wall;
    }

    @Override
    public boolean fitsHorizontally(int width) {
        switch (this.expandBehaviour) {
            case MergedRepeat: {
                if (width == 1) {
                    return false;
                }
                return width % (this.defaultWidth - 1) == 1;
            }
            case Repeat: {
                return width % this.defaultWidth == 0;
            }
        }
        return super.fitsHorizontally(width);
    }

    @Override
    public void getBlocks(Design.DesignInstance instance, Map<BlockPos, PaletteBlockInfo> blocks) {
        if (this.expandBehaviour == ExpandBehaviour.None) {
            super.getBlocks(instance, blocks);
        } else {
            boolean merge = this.expandBehaviour == ExpandBehaviour.MergedRepeat;
            int instances = merge ? (instance.width - 1) / (this.defaultWidth - 1) : instance.width / this.defaultWidth;
            int multiplierWidth = merge ? this.defaultWidth - 1 : this.defaultWidth;
            for (int i = 0; i < instances; ++i) {
                BlockPos shift = new BlockPos(i * multiplierWidth, 0, 0);
                super.getBlocksShifted(instance, blocks, shift);
            }
        }
    }

    public static enum ExpandBehaviour {
        None,
        Repeat,
        MergedRepeat;

    }
}

