/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.design.DesignPicker;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.foundation.utility.DesignHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

public class TemporaryDesignCache {
    Map<Vector<Integer>, Design> designs = new HashMap<Vector<Integer>, Design>();
    Map<Room, DesignPicker.RoomDesignMapping> roomDesigns;
    Map<Stack, Design> roofDesigns;
    Random random;

    public TemporaryDesignCache(Map<Room, DesignPicker.RoomDesignMapping> roomDesigns, Map<Stack, Design> roofDesigns, int seed) {
        this.roomDesigns = roomDesigns;
        this.roofDesigns = roofDesigns;
        this.random = new Random(seed);
    }

    public boolean hasCachedRoom(Room room) {
        return this.roomDesigns.containsKey(room);
    }

    public boolean hasCachedRoof(Stack stack) {
        return this.roofDesigns.containsKey(stack);
    }

    public DesignPicker.RoomDesignMapping getCachedRoom(Room room) {
        return this.roomDesigns.get(room);
    }

    public Design getCachedRoof(Stack stack) {
        return this.roofDesigns.get(stack);
    }

    public void cacheRoom(Room room, DesignPicker.RoomDesignMapping value) {
        this.roomDesigns.put(room, value);
    }

    public void cacheRoof(Stack stack, Design roof) {
        this.roofDesigns.put(stack, roof);
    }

    public Design find(DesignQuery query) {
        Vector<Integer> key = query.asCacheKey();
        if (this.designs.containsKey(key)) {
            return this.designs.get(key);
        }
        Design design = DesignHelper.pickRandom(query, this.random);
        this.designs.put(key, design);
        return design;
    }

    public Random getRandom() {
        return this.random;
    }
}

