/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels;

import com.google.common.collect.Sets;
import com.tfar.metalbarrels.block.CrystalBarrelBlock;
import com.tfar.metalbarrels.block.MetalBarrelBlock;
import com.tfar.metalbarrels.container.MetalBarrelContainer;
import com.tfar.metalbarrels.item.BarrelUpgradeItem;
import com.tfar.metalbarrels.item.UpgradeInfo;
import com.tfar.metalbarrels.network.PacketHandler;
import com.tfar.metalbarrels.screens.MetalBarrelScreen;
import com.tfar.metalbarrels.tile.MetalBarrelBlockEntity;
import com.tfar.metalbarrels.util.MetalBarrelBlockEntityType;
import com.tfar.metalbarrels.util.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.data.BlockStateVariantBuilder;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="metalbarrels")
public class MetalBarrels {
    public static final String MODID = "metalbarrels";
    public static final Logger logger = LogManager.getLogger();
    public static final ItemGroup tab = new ItemGroup("metalbarrels"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ObjectHolders.DIAMOND_BARREL);
        }
    };

    public MetalBarrels() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BarrelUpgradeItem.IRON_CHESTS_LOADED = ModList.get().isLoaded("ironchest");
        PacketHandler.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ObjectHolders.COPPER_CONTAINER, MetalBarrelScreen::copper);
        ScreenManager.func_216911_a(ObjectHolders.IRON_CONTAINER, MetalBarrelScreen::iron);
        ScreenManager.func_216911_a(ObjectHolders.SILVER_CONTAINER, MetalBarrelScreen::silver);
        ScreenManager.func_216911_a(ObjectHolders.GOLD_CONTAINER, MetalBarrelScreen::gold);
        ScreenManager.func_216911_a(ObjectHolders.DIAMOND_CONTAINER, MetalBarrelScreen::diamond);
        ScreenManager.func_216911_a(ObjectHolders.NETHERITE_CONTAINER, MetalBarrelScreen::netherite);
    }

    @ObjectHolder(value="metalbarrels")
    public static class ObjectHolders {
        public static final Block COPPER_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> COPPER_CONTAINER = null;
        public static final TileEntityType<MetalBarrelBlockEntity> COPPER_TILE = null;
        public static final Block IRON_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> IRON_CONTAINER = null;
        public static final TileEntityType<MetalBarrelBlockEntity> IRON_TILE = null;
        public static final Block GOLD_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> GOLD_CONTAINER = null;
        public static final TileEntityType<MetalBarrelBlockEntity> GOLD_TILE = null;
        public static final Block DIAMOND_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> DIAMOND_CONTAINER = null;
        public static final TileEntityType<MetalBarrelBlockEntity> DIAMOND_TILE = null;
        public static final Block NETHERITE_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> NETHERITE_CONTAINER = null;
        public static final TileEntityType<MetalBarrelBlockEntity> NETHERITE_TILE = null;
        public static final Block OBSIDIAN_BARREL = null;
        public static final Block SILVER_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> SILVER_CONTAINER = null;
        public static final TileEntityType<MetalBarrelBlockEntity> SILVER_TILE = null;
        public static final Block CRYSTAL_BARREL = null;
        public static final TileEntityType<MetalBarrelBlockEntity> CRYSTAL_TILE = null;
    }

    @ObjectHolder(value="ironchest")
    public static class IronChestObjectHolders {
        public static final Block COPPER_CHEST = null;
        public static final Block IRON_CHEST = null;
        public static final Block SILVER_CHEST = null;
        public static final Block GOLD_CHEST = null;
        public static final Block DIAMOND_CHEST = null;
        public static final Block CRYSTAL_CHEST = null;
        public static final Block OBSIDIAN_CHEST = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        private static final Set<Block> MOD_BLOCKS = new HashSet<Block>();

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            AbstractBlock.Properties metal = AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.5f, 6.0f).func_200947_a(SoundType.field_185852_e);
            AbstractBlock.Properties softmetal = metal.harvestLevel(1);
            AbstractBlock.Properties hardmetal = metal.harvestLevel(2);
            AbstractBlock.Properties obsidian = AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(15.0f, 6000.0f);
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(softmetal, () -> new MetalBarrelBlockEntity(ObjectHolders.COPPER_TILE)), "copper_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(softmetal, () -> new MetalBarrelBlockEntity(ObjectHolders.IRON_TILE)), "iron_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(hardmetal, () -> new MetalBarrelBlockEntity(ObjectHolders.SILVER_TILE)), "silver_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(hardmetal, () -> new MetalBarrelBlockEntity(ObjectHolders.GOLD_TILE)), "gold_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(hardmetal, () -> new MetalBarrelBlockEntity(ObjectHolders.DIAMOND_TILE)), "diamond_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(obsidian, () -> new MetalBarrelBlockEntity(ObjectHolders.DIAMOND_TILE)), "obsidian_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(obsidian, () -> new MetalBarrelBlockEntity(ObjectHolders.NETHERITE_TILE)), "netherite_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new CrystalBarrelBlock(hardmetal.func_226896_b_(), () -> new MetalBarrelBlockEntity(ObjectHolders.DIAMOND_TILE)), "crystal_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
        }

        private static void registerBlock(Block block, String name, IForgeRegistry<Block> registry) {
            registry.register(block.setRegistryName(name));
            MOD_BLOCKS.add(block);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            IForgeRegistry registry = itemRegistryEvent.getRegistry();
            for (Block block : MOD_BLOCKS) {
                Item.Properties properties = new Item.Properties().func_200916_a(tab);
                if (block == ObjectHolders.NETHERITE_BARREL) {
                    properties.func_234689_a_();
                }
                BlockItem item = new BlockItem(block, properties);
                RegistryEvents.registerItem((Item)item, block.getRegistryName().toString(), (IForgeRegistry<Item>)registry);
            }
            Item.Properties properties = new Item.Properties().func_200916_a(tab);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.COPPER_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.COPPER_CHEST, "ironchest")), "wood_to_copper", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.IRON_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.IRON_CHEST, "ironchest")), "wood_to_iron", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "wood_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "wood_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "wood_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "wood_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.NETHERITE_BARREL)))), "wood_to_netherite", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.IRON_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.IRON_CHEST, "ironchest")), "copper_to_iron", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "copper_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "copper_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "copper_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "copper_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "iron_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "iron_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "iron_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "iron_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "silver_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "silver_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "silver_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(ModTags.Blocks.GOLD_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "gold_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.GOLD_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "gold_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.DIAMOND_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(ModTags.Blocks.DIAMOND_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "diamond_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add((ITag.INamedTag<Block>)Tags.Blocks.CHESTS_WOODEN, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "wood_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.COPPER_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "copper_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.IRON_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "iron_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.SILVER_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "silver_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.GOLD_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "gold_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<ITag.INamedTag<Block>>(Collections.singleton(ModTags.Blocks.DIAMOND_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(ModTags.Blocks.DIAMOND_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "diamond_to_crystal", (IForgeRegistry<Item>)registry);
        }

        private static void registerItem(Item item, String name, IForgeRegistry<Item> registry) {
            registry.register(item.setRegistryName(name));
        }

        @SubscribeEvent
        public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(new ContainerType(MetalBarrelContainer::copper).setRegistryName("copper_container"));
            event.getRegistry().register(new ContainerType(MetalBarrelContainer::iron).setRegistryName("iron_container"));
            event.getRegistry().register(new ContainerType(MetalBarrelContainer::silver).setRegistryName("silver_container"));
            event.getRegistry().register(new ContainerType(MetalBarrelContainer::gold).setRegistryName("gold_container"));
            event.getRegistry().register(new ContainerType(MetalBarrelContainer::diamond).setRegistryName("diamond_container"));
            event.getRegistry().register(new ContainerType(MetalBarrelContainer::netherite).setRegistryName("netherite_container"));
        }

        @SubscribeEvent
        public static void registerTiles(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.COPPER_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.COPPER_BARREL}), null, 9, 5, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::copperS)).setRegistryName("copper_tile"));
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.IRON_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.IRON_BARREL}), null, 9, 6, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::ironS)).setRegistryName("iron_tile"));
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.SILVER_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.SILVER_BARREL}), null, 9, 8, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::silverS)).setRegistryName("silver_tile"));
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.GOLD_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.GOLD_BARREL}), null, 9, 9, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::goldS)).setRegistryName("gold_tile"));
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.DIAMOND_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.DIAMOND_BARREL, ObjectHolders.OBSIDIAN_BARREL}), null, 12, 9, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::diamondS)).setRegistryName("diamond_tile"));
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.NETHERITE_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.NETHERITE_BARREL}), null, 15, 9, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::netheriteS)).setRegistryName("netherite_tile"));
            event.getRegistry().register(new MetalBarrelBlockEntityType<MetalBarrelBlockEntity>(() -> new MetalBarrelBlockEntity(ObjectHolders.CRYSTAL_TILE), Sets.newHashSet((Object[])new Block[]{ObjectHolders.CRYSTAL_BARREL}), null, 12, 9, (BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container>)((BlockStateVariantBuilder.ITriFunction)MetalBarrelContainer::diamondS)).setRegistryName("crystal_tile"));
        }
    }
}

