/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2CSyncBarrelStacks {
    private final int dimension;
    private final BlockPos pos;
    private final NonNullList<ItemStack> topStacks;

    public S2CSyncBarrelStacks(int dimension, BlockPos pos, NonNullList<ItemStack> topStacks) {
        this.dimension = dimension;
        this.pos = pos;
        this.topStacks = topStacks;
    }

    public static void encode(S2CSyncBarrelStacks msg, PacketBuffer buf) {
        buf.writeInt(msg.dimension);
        buf.writeInt(msg.pos.func_177958_n());
        buf.writeInt(msg.pos.func_177956_o());
        buf.writeInt(msg.pos.func_177952_p());
        buf.writeInt(msg.topStacks.size());
        for (ItemStack stack : msg.topStacks) {
            buf.func_150788_a(stack);
        }
    }

    public static S2CSyncBarrelStacks decode(PacketBuffer buf) {
        int dimension = buf.readInt();
        BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int size = buf.readInt();
        NonNullList topStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int item = 0; item < size; ++item) {
            ItemStack itemStack = buf.func_150791_c();
            topStacks.set(item, (Object)itemStack);
        }
        return new S2CSyncBarrelStacks(dimension, pos, (NonNullList<ItemStack>)topStacks);
    }

    public static class Handler {
        public static void handle(S2CSyncBarrelStacks message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                World world = (World)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71441_e);
                if (world != null) {
                    TileEntity tileEntity = world.func_175625_s(message.pos);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

