/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.VanillaPaxelMaterialCreator;
import mekanism.tools.common.material.impl.BronzeMaterialDefaults;
import mekanism.tools.common.material.impl.LapisLazuliMaterialDefaults;
import mekanism.tools.common.material.impl.OsmiumMaterialDefaults;
import mekanism.tools.common.material.impl.RefinedGlowstoneMaterialDefaults;
import mekanism.tools.common.material.impl.RefinedObsidianMaterialDefaults;
import mekanism.tools.common.material.impl.SteelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.DiamondPaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.GoldPaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.IronPaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.NetheritePaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.StonePaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.WoodPaxelMaterialDefaults;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ToolsConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedDoubleValue armorSpawnRate;
    public final ArmorSpawnChanceConfig bronzeSpawnRate;
    public final ArmorSpawnChanceConfig lapisLazuliSpawnRate;
    public final ArmorSpawnChanceConfig osmiumSpawnRate;
    public final ArmorSpawnChanceConfig refinedGlowstoneSpawnRate;
    public final ArmorSpawnChanceConfig refinedObsidianSpawnRate;
    public final ArmorSpawnChanceConfig steelSpawnRate;
    public final VanillaPaxelMaterialCreator wood;
    public final VanillaPaxelMaterialCreator stone;
    public final VanillaPaxelMaterialCreator iron;
    public final VanillaPaxelMaterialCreator diamond;
    public final VanillaPaxelMaterialCreator gold;
    public final VanillaPaxelMaterialCreator netherite;
    public final MaterialCreator bronze;
    public final MaterialCreator lapisLazuli;
    public final MaterialCreator osmium;
    public final MaterialCreator refinedGlowstone;
    public final MaterialCreator refinedObsidian;
    public final MaterialCreator steel;

    ToolsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Tools Config. This config is synced from server to client.").push("tools");
        builder.push("mobArmorSpawnRate");
        this.armorSpawnRate = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that Mekanism Armor can spawn on mobs.").defineInRange("general", 0.03, 0.0, 1.0));
        this.bronzeSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "bronze", "Bronze", 0.5, 0.5, 0.5, 0.5, 0.5);
        this.lapisLazuliSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "lapis_lazuli", "Lapis Lazuli", 0.5, 0.5, 0.5, 0.5, 0.5);
        this.osmiumSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "osmium", "Osmium", 0.5, 0.5, 0.5, 0.5, 0.5);
        this.refinedGlowstoneSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "refined_glowstone", "Refined Glowstone", 0.5, 0.5, 0.5, 0.5, 0.5);
        this.refinedObsidianSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "refined_obsidian", "Refined Obsidian", 0.5, 0.5, 0.5, 0.5, 0.5);
        this.steelSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "steel", "Steel", 0.5, 0.5, 0.5, 0.5, 0.5);
        builder.pop();
        this.wood = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new WoodPaxelMaterialDefaults());
        this.stone = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new StonePaxelMaterialDefaults());
        this.iron = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new IronPaxelMaterialDefaults());
        this.diamond = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new DiamondPaxelMaterialDefaults());
        this.gold = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new GoldPaxelMaterialDefaults());
        this.netherite = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new NetheritePaxelMaterialDefaults());
        this.bronze = new MaterialCreator((IMekanismConfig)this, builder, new BronzeMaterialDefaults());
        this.lapisLazuli = new MaterialCreator((IMekanismConfig)this, builder, new LapisLazuliMaterialDefaults());
        this.osmium = new MaterialCreator((IMekanismConfig)this, builder, new OsmiumMaterialDefaults());
        this.refinedGlowstone = new MaterialCreator((IMekanismConfig)this, builder, new RefinedGlowstoneMaterialDefaults());
        this.refinedObsidian = new MaterialCreator((IMekanismConfig)this, builder, new RefinedObsidianMaterialDefaults());
        this.steel = new MaterialCreator((IMekanismConfig)this, builder, new SteelMaterialDefaults());
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "tools";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public static class ArmorSpawnChanceConfig {
        public final CachedDoubleValue swordChance;
        public final CachedDoubleValue helmetChance;
        public final CachedDoubleValue chestplateChance;
        public final CachedDoubleValue leggingsChance;
        public final CachedDoubleValue bootsChance;

        private ArmorSpawnChanceConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, String armorKey, String armor, double swordChance, double helmetChance, double chestplateChance, double leggingsChance, double bootsChance) {
            builder.comment("Spawn chances for pieces of " + armor + " gear. Note: These values are after the general mobArmorSpawnRate has been checked, and after an even split between armor types has been done.").push(armorKey);
            this.swordChance = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Swords.").defineInRange("swordChance", swordChance, 0.0, 1.0));
            this.helmetChance = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Helmets.").defineInRange("helmetChance", helmetChance, 0.0, 1.0));
            this.chestplateChance = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Chestplates.").defineInRange("chestplateChance", chestplateChance, 0.0, 1.0));
            this.leggingsChance = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Leggings.").defineInRange("leggingsChance", leggingsChance, 0.0, 1.0));
            this.bootsChance = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Boots.").defineInRange("bootsChance", bootsChance, 0.0, 1.0));
            builder.pop();
        }
    }
}

