/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    private boolean seesSun;
    protected FloatingLong peakOutput = FloatingLong.ZERO;
    private FloatingLong lastProductionAmount = FloatingLong.ZERO;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;
    @Nullable
    protected SolarCheck solarCheck;

    public TileEntitySolarGenerator() {
        this((IBlockProvider)GeneratorsBlocks.SOLAR_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.solarGeneration.get()).multiply(2L));
    }

    public TileEntitySolarGenerator(IBlockProvider blockProvider, @Nonnull FloatingLong output) {
        super(blockProvider, output);
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntitySolarGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @ComputerMethod
    public boolean canSeeSun() {
        return this.seesSun;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.solarCheck == null) {
            this.recheckSettings();
        }
        this.energySlot.drainContainer();
        this.seesSun = this.checkCanSeeSun();
        if (this.seesSun && MekanismUtils.canFunction((TileEntityMekanism)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            this.setActive(true);
            FloatingLong production = this.getProduction();
            this.lastProductionAmount = production.subtract(this.getEnergyContainer().insert(production, Action.EXECUTE, AutomationType.INTERNAL));
        } else {
            this.setActive(false);
            this.lastProductionAmount = FloatingLong.ZERO;
        }
    }

    protected void recheckSettings() {
        if (this.field_145850_b == null) {
            return;
        }
        this.solarCheck = new SolarCheck(this.field_145850_b, this.field_174879_c);
        this.peakOutput = this.getConfiguredMax().multiply((double)this.solarCheck.getPeakMultiplier());
    }

    protected boolean checkCanSeeSun() {
        if (this.solarCheck == null) {
            return false;
        }
        this.solarCheck.recheckCanSeeSun();
        return this.solarCheck.canSeeSun();
    }

    public FloatingLong getProduction() {
        if (this.field_145850_b == null || this.solarCheck == null) {
            return FloatingLong.ZERO;
        }
        float brightness = this.getBrightnessMultiplier(this.field_145850_b);
        return this.getConfiguredMax().multiply((double)(brightness * this.solarCheck.getGenerationMultiplier()));
    }

    protected float getBrightnessMultiplier(@Nonnull World world) {
        return WorldUtils.getSunBrightness((World)world, (float)1.0f);
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.BOTTOM};
    }

    protected FloatingLong getConfiguredMax() {
        return (FloatingLong)MekanismGeneratorsConfig.generators.solarGeneration.get();
    }

    @Override
    public FloatingLong getMaxOutput() {
        return this.peakOutput;
    }

    @ComputerMethod(nameOverride="getProductionRate")
    public FloatingLong getLastProductionAmount() {
        return this.lastProductionAmount;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::canSeeSun, value -> {
            this.seesSun = value;
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(this::getMaxOutput, value -> {
            this.peakOutput = value;
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(this::getLastProductionAmount, value -> {
            this.lastProductionAmount = value;
        }));
    }

    protected static class SolarCheck {
        private final boolean needsRainCheck;
        private final float peakMultiplier;
        protected final BlockPos pos;
        protected final World world;
        protected boolean canSeeSun;

        public SolarCheck(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
            Biome b = this.world.func_225523_d_().func_226836_a_(this.pos);
            this.needsRainCheck = b.func_201851_b() != Biome.RainType.NONE;
            float tempEff = 0.3f * (0.8f - b.func_225486_c(this.pos));
            float humidityEff = this.needsRainCheck ? -0.3f * b.func_76727_i() : 0.0f;
            this.peakMultiplier = 1.0f + tempEff + humidityEff;
        }

        public void recheckCanSeeSun() {
            this.canSeeSun = WorldUtils.canSeeSun((World)this.world, (BlockPos)this.pos);
        }

        public boolean canSeeSun() {
            return this.canSeeSun;
        }

        public float getPeakMultiplier() {
            return this.peakMultiplier;
        }

        public float getGenerationMultiplier() {
            if (!this.canSeeSun) {
                return 0.0f;
            }
            if (this.needsRainCheck && (this.world.func_72896_J() || this.world.func_72911_I())) {
                return this.peakMultiplier * 0.2f;
            }
            return this.peakMultiplier;
        }
    }
}

