/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class RenderFissionReactor
extends MekanismTileEntityRenderer<TileEntityFissionReactorCasing> {
    private static final Map<RenderData, MekanismRenderer.Model3D> cachedHeatedCoolantModels = new Object2ObjectOpenHashMap();
    private static final int GLOW_ARGB = MekanismRenderer.getColorARGB((float)0.466f, (float)0.882f, (float)0.929f, (float)0.6f);
    private static MekanismRenderer.Model3D glowModel;

    public static void resetCachedModels() {
        cachedHeatedCoolantModels.clear();
        glowModel = null;
    }

    public RenderFissionReactor(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityFissionReactorCasing tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        FissionReactorMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (FissionReactorMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null) {
            int glow;
            FluidRenderData data;
            int height;
            BlockPos pos = tile.func_174877_v();
            IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
            if (multiblock.isBurning()) {
                if (glowModel == null) {
                    glowModel = new MekanismRenderer.Model3D();
                    RenderFissionReactor.glowModel.minX = 0.05f;
                    RenderFissionReactor.glowModel.minY = 0.01f;
                    RenderFissionReactor.glowModel.minZ = 0.05f;
                    RenderFissionReactor.glowModel.maxX = 0.95f;
                    RenderFissionReactor.glowModel.maxY = 0.99f;
                    RenderFissionReactor.glowModel.maxZ = 0.95f;
                    glowModel.setTexture(MekanismRenderer.whiteIcon);
                }
                for (FissionReactorValidator.FormedAssembly assembly : multiblock.assemblies) {
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)(assembly.getPos().func_177958_n() - pos.func_177958_n()), (double)(assembly.getPos().func_177956_o() - pos.func_177956_o()), (double)(assembly.getPos().func_177952_p() - pos.func_177952_p()));
                    matrix.func_227862_a_(1.0f, (float)assembly.getHeight(), 1.0f);
                    MekanismRenderer.renderObject((MekanismRenderer.Model3D)glowModel, (MatrixStack)matrix, (IVertexBuilder)buffer, (int)GLOW_ARGB, (int)0xF000F0, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT);
                    matrix.func_227865_b_();
                }
            }
            if (!multiblock.fluidCoolantTank.isEmpty() && (height = multiblock.height() - 2) >= 1) {
                data = new FluidRenderData(multiblock.fluidCoolantTank.getFluid());
                glow = this.setCoolantDataAndCalculateGlow((RenderData)data, multiblock, height);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(data.location.func_177958_n() - pos.func_177958_n()), (double)(data.location.func_177956_o() - pos.func_177956_o()), (double)(data.location.func_177952_p() - pos.func_177952_p()));
                MekanismRenderer.Model3D model = ModelRenderer.getModel((RenderData)data, (double)multiblock.prevCoolantScale);
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)model, (MatrixStack)matrix, (IVertexBuilder)buffer, (int)data.getColorARGB(multiblock.prevCoolantScale), (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)this.getFaceDisplay((RenderData)data, model));
                matrix.func_227865_b_();
                MekanismRenderer.renderValves((MatrixStack)matrix, (IVertexBuilder)buffer, (Set)multiblock.valves, (FluidRenderData)data, (BlockPos)pos, (int)glow, (int)overlayLight, (BooleanSupplier)this.isInsideMultiblock((RenderData)data));
            }
            if (!multiblock.heatedCoolantTank.isEmpty() && (height = multiblock.height() - 2) >= 1) {
                MekanismRenderer.Model3D gasModel;
                data = new ChemicalRenderData.GasRenderData((GasStack)multiblock.heatedCoolantTank.getStack());
                glow = this.setCoolantDataAndCalculateGlow((RenderData)data, multiblock, height);
                if (cachedHeatedCoolantModels.containsKey(data)) {
                    gasModel = cachedHeatedCoolantModels.get(data);
                } else {
                    gasModel = ModelRenderer.getModel((RenderData)data, (double)1.0).copy();
                    gasModel.minX += 0.01f;
                    gasModel.minY += 0.01f;
                    gasModel.minZ += 0.01f;
                    gasModel.maxX -= 0.01f;
                    gasModel.maxY -= 0.01f;
                    gasModel.maxZ -= 0.01f;
                    cachedHeatedCoolantModels.put((RenderData)data, gasModel);
                }
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(data.location.func_177958_n() - pos.func_177958_n()), (double)(data.location.func_177956_o() - pos.func_177956_o()), (double)(data.location.func_177952_p() - pos.func_177952_p()));
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)gasModel, (MatrixStack)matrix, (IVertexBuilder)buffer, (int)data.getColorARGB(multiblock.prevHeatedCoolantScale), (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)this.getFaceDisplay((RenderData)data, gasModel));
                matrix.func_227865_b_();
            }
        }
    }

    private int setCoolantDataAndCalculateGlow(RenderData data, FissionReactorMultiblockData multiblock, int height) {
        data.location = multiblock.renderLocation;
        data.height = height;
        data.length = multiblock.length();
        data.width = multiblock.width();
        return data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
    }

    protected String getProfilerSection() {
        return "fissionReactor";
    }

    public boolean shouldRenderOffScreen(TileEntityFissionReactorCasing tile) {
        if (tile.isMaster()) {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.renderLocation != null;
        }
        return false;
    }
}

