/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.registries;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import mekanism.additions.common.block.BlockGlowPanel;
import mekanism.additions.common.block.BlockObsidianTNT;
import mekanism.additions.common.block.plastic.BlockPlastic;
import mekanism.additions.common.block.plastic.BlockPlasticFence;
import mekanism.additions.common.block.plastic.BlockPlasticFenceGate;
import mekanism.additions.common.block.plastic.BlockPlasticRoad;
import mekanism.additions.common.block.plastic.BlockPlasticSlab;
import mekanism.additions.common.block.plastic.BlockPlasticStairs;
import mekanism.additions.common.block.plastic.BlockPlasticTransparent;
import mekanism.additions.common.block.plastic.BlockPlasticTransparentSlab;
import mekanism.additions.common.block.plastic.BlockPlasticTransparentStairs;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.item.block.ItemBlockColoredName;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;

public class AdditionsBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("mekanismadditions");
    public static final BlockRegistryObject<BlockObsidianTNT, BlockItem> OBSIDIAN_TNT = BLOCKS.register("obsidian_tnt", BlockObsidianTNT::new);
    public static final Map<EnumColor, BlockRegistryObject<BlockGlowPanel, ItemBlockColoredName>> GLOW_PANELS = new EnumMap<EnumColor, BlockRegistryObject<BlockGlowPanel, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>> PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>> SLICK_PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>> PLASTIC_GLOW_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>> REINFORCED_PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticRoad, ItemBlockColoredName>> PLASTIC_ROADS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticRoad, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticTransparent, ItemBlockColoredName>> TRANSPARENT_PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticTransparent, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockColoredName>> PLASTIC_STAIRS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockColoredName>> PLASTIC_SLABS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticFence, ItemBlockColoredName>> PLASTIC_FENCES = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticFence, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticFenceGate, ItemBlockColoredName>> PLASTIC_FENCE_GATES = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticFenceGate, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockColoredName>> PLASTIC_GLOW_STAIRS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockColoredName>> PLASTIC_GLOW_SLABS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticTransparentStairs, ItemBlockColoredName>> TRANSPARENT_PLASTIC_STAIRS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticTransparentStairs, ItemBlockColoredName>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticTransparentSlab, ItemBlockColoredName>> TRANSPARENT_PLASTIC_SLABS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticTransparentSlab, ItemBlockColoredName>>(EnumColor.class);

    private AdditionsBlocks() {
    }

    private static BlockRegistryObject<BlockPlastic, ItemBlockColoredName> registerPlastic(EnumColor color, String blockTypeSuffix, UnaryOperator<AbstractBlock.Properties> propertyModifier) {
        return AdditionsBlocks.registerColoredBlock(c -> new BlockPlastic((EnumColor)c, propertyModifier), blockTypeSuffix, color);
    }

    private static BlockRegistryObject<BlockPlasticSlab, ItemBlockColoredName> registerPlasticSlab(EnumColor color, String blockTypeSuffix, UnaryOperator<AbstractBlock.Properties> propertyModifier) {
        return AdditionsBlocks.registerColoredBlock(c -> new BlockPlasticSlab((EnumColor)c, propertyModifier), blockTypeSuffix, color);
    }

    private static BlockRegistryObject<BlockPlasticStairs, ItemBlockColoredName> registerPlasticStairs(IBlockProvider baseBlock, EnumColor color, String blockTypeSuffix, UnaryOperator<AbstractBlock.Properties> propertyModifier) {
        return AdditionsBlocks.registerColoredBlock(c -> new BlockPlasticStairs(baseBlock, (EnumColor)c, propertyModifier), blockTypeSuffix, color);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockColoredName> registerColoredBlock(Function<EnumColor, BLOCK> blockCreator, String blockTypeSuffix, EnumColor color) {
        return BLOCKS.register(color.getRegistryPrefix() + blockTypeSuffix, () -> (Block)blockCreator.apply(color), x$0 -> new ItemBlockColoredName((Block)x$0));
    }

    static {
        for (EnumColor color : EnumUtils.COLORS) {
            GLOW_PANELS.put(color, AdditionsBlocks.registerColoredBlock(BlockGlowPanel::new, "_glow_panel", color));
            BlockRegistryObject<BlockPlastic, ItemBlockColoredName> plasticBlockRO = AdditionsBlocks.registerPlastic(color, "_plastic", properties -> properties.func_200948_a(5.0f, 6.0f));
            PLASTIC_BLOCKS.put(color, plasticBlockRO);
            SLICK_PLASTIC_BLOCKS.put(color, AdditionsBlocks.registerPlastic(color, "_slick_plastic", properties -> properties.func_200948_a(5.0f, 6.0f).func_200941_a(0.98f)));
            BlockRegistryObject<BlockPlastic, ItemBlockColoredName> plasticGlowBlockRO = AdditionsBlocks.registerPlastic(color, "_plastic_glow", properties -> properties.func_200948_a(5.0f, 6.0f).func_235838_a_(state -> 10));
            PLASTIC_GLOW_BLOCKS.put(color, plasticGlowBlockRO);
            REINFORCED_PLASTIC_BLOCKS.put(color, AdditionsBlocks.registerPlastic(color, "_reinforced_plastic", properties -> properties.func_200948_a(50.0f, 1200.0f)));
            PLASTIC_ROADS.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticRoad::new, "_plastic_road", color));
            BlockRegistryObject<BlockPlasticTransparent, ItemBlockColoredName> transparentPlasticRO = AdditionsBlocks.registerColoredBlock(BlockPlasticTransparent::new, "_plastic_transparent", color);
            TRANSPARENT_PLASTIC_BLOCKS.put(color, transparentPlasticRO);
            PLASTIC_STAIRS.put(color, AdditionsBlocks.registerPlasticStairs(plasticBlockRO, color, "_plastic_stairs", UnaryOperator.identity()));
            PLASTIC_SLABS.put(color, AdditionsBlocks.registerPlasticSlab(color, "_plastic_slab", UnaryOperator.identity()));
            PLASTIC_FENCES.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticFence::new, "_plastic_fence", color));
            PLASTIC_FENCE_GATES.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticFenceGate::new, "_plastic_fence_gate", color));
            PLASTIC_GLOW_STAIRS.put(color, AdditionsBlocks.registerPlasticStairs(plasticGlowBlockRO, color, "_plastic_glow_stairs", properties -> properties.func_235838_a_(state -> 10)));
            PLASTIC_GLOW_SLABS.put(color, AdditionsBlocks.registerPlasticSlab(color, "_plastic_glow_slab", properties -> properties.func_235838_a_(state -> 10)));
            TRANSPARENT_PLASTIC_STAIRS.put(color, AdditionsBlocks.registerColoredBlock(c -> new BlockPlasticTransparentStairs((IBlockProvider)transparentPlasticRO, (EnumColor)c), "_plastic_transparent_stairs", color));
            TRANSPARENT_PLASTIC_SLABS.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticTransparentSlab::new, "_plastic_transparent_slab", color));
        }
    }
}

