/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.IntSupplier;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.WorldConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class ResizableSphereReplaceConfig
implements IFeatureConfig {
    public static final Codec<ResizableSphereReplaceConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.field_235877_b_.fieldOf("state").forGetter(config -> config.state)).apply((Applicative)builder, state -> new ResizableSphereReplaceConfig((BlockState)state, MekanismConfig.world.salt)));
    public final BlockState state;
    public final IntSupplier baseRadius;
    public final IntSupplier spread;
    public final IntSupplier ySize;
    public final List<BlockState> targets;

    public ResizableSphereReplaceConfig(BlockState state, WorldConfig.SaltConfig saltConfig) {
        this.state = state;
        this.baseRadius = saltConfig.baseRadius;
        this.spread = saltConfig.spread;
        this.ySize = saltConfig.ySize;
        this.targets = ImmutableList.of((Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_150435_aG.func_176223_P(), (Object)this.state);
    }

    public int getRadius(Random rand) {
        int spread = this.spread.getAsInt();
        return spread == 0 ? this.baseRadius.getAsInt() : this.baseRadius.getAsInt() + rand.nextInt(spread + 1);
    }
}

