/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.RelativeSide;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.IModuleItem;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TileEntityModificationStation
extends TileEntityMekanism
implements IBoundingBlock {
    private static final int BASE_TICKS_REQUIRED = 40;
    public int ticksRequired = 40;
    public int operatingTicks;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getModuleItem"})
    private InputInventorySlot moduleSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getContainerItem"})
    public InputInventorySlot containerSlot;
    private MachineEnergyContainer<TileEntityModificationStation> energyContainer;

    public TileEntityModificationStation() {
        super(MekanismBlocks.MODIFICATION_STATION);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    public MachineEnergyContainer<TileEntityModificationStation> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.moduleSlot = InputInventorySlot.at(stack -> stack.func_77973_b() instanceof IModuleItem, this, 35, 118);
        builder.addSlot(this.moduleSlot);
        this.containerSlot = InputInventorySlot.at(stack -> stack.func_77973_b() instanceof IModuleContainerItem, this, 125, 118);
        builder.addSlot(this.containerSlot);
        this.moduleSlot.setSlotType(ContainerSlotType.NORMAL);
        this.moduleSlot.setSlotOverlay(SlotOverlay.MODULE);
        this.containerSlot.setSlotType(ContainerSlotType.NORMAL);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityModificationStation)this).func_145831_w(), this, 149, 21);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (MekanismUtils.canFunction(this)) {
            boolean operated = false;
            if (this.energyContainer.getEnergy().greaterOrEqual(this.energyContainer.getEnergyPerTick()) && !this.moduleSlot.isEmpty() && !this.containerSlot.isEmpty()) {
                IModule<?> module;
                ModuleData<?> data = ((IModuleItem)this.moduleSlot.getStack().func_77973_b()).getModuleData();
                ItemStack stack = this.containerSlot.getStack();
                if (MekanismAPI.getModuleHelper().getSupported(stack).contains(data) && ((module = MekanismAPI.getModuleHelper().load(stack, data)) == null || module.getInstalledCount() < data.getMaxStackSize())) {
                    operated = true;
                    ++this.operatingTicks;
                    this.energyContainer.extract(this.energyContainer.getEnergyPerTick(), Action.EXECUTE, AutomationType.INTERNAL);
                    if (this.operatingTicks == this.ticksRequired) {
                        this.operatingTicks = 0;
                        ((IModuleContainerItem)stack.func_77973_b()).addModule(stack, data);
                        this.containerSlot.setStack(stack);
                        MekanismUtils.logMismatchedStackSize(this.moduleSlot.shrinkStack(1, Action.EXECUTE), 1L);
                    }
                }
            }
            if (!operated) {
                this.operatingTicks = 0;
            }
        }
    }

    public void removeModule(PlayerEntity player, ModuleData<?> type) {
        IModuleContainerItem container;
        ItemStack stack = this.containerSlot.getStack();
        if (!stack.func_190926_b() && (container = (IModuleContainerItem)stack.func_77973_b()).hasModule(stack, type) && player.field_71071_by.func_70441_a(type.getItemProvider().getItemStack())) {
            container.removeModule(stack, type);
            this.containerSlot.setStack(stack);
        }
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("progress");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("progress", this.operatingTicks);
        return nbtTags;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.operatingTicks, value -> {
            this.operatingTicks = value;
        }));
    }

    @Override
    public void onPlace() {
        super.onPlace();
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
        Direction side = this.getRightSide();
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177972_a(side), this.func_174877_v());
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177972_a(side).func_177984_a(), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
            BlockPos rightPos = this.func_174877_v().func_177972_a(this.getRightSide());
            this.field_145850_b.func_217377_a(rightPos, false);
            this.field_145850_b.func_217377_a(rightPos.func_177984_a(), false);
        }
    }
}

