/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.slot.InternalInventorySlot;
import mekanism.common.lib.SidedBlockPos;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;

public class TileEntityLogisticalSorter
extends TileEntityMekanism
implements ISustainedData,
ITileFilterHolder<SorterFilter<?>>,
IHasSortableFilters {
    private HashList<SorterFilter<?>> filters = new HashList();
    private final Finder strictFinder = stack -> this.filters.stream().noneMatch(filter -> !filter.allowDefault && filter.getFinder().modifies(stack));
    @SyntheticComputerMethod(getter="getDefaultColor")
    public EnumColor color;
    private boolean autoEject;
    private boolean roundRobin;
    private boolean singleItem;
    @Nullable
    public SidedBlockPos rrTarget;
    private int delayTicks;

    public TileEntityLogisticalSorter() {
        super(MekanismBlocks.LOGISTICAL_SORTER);
        this.delaySupplier = () -> 3;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        builder.addSlot(InternalInventorySlot.create(this), RelativeSide.FRONT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 6) {
            this.setActive(false);
        }
        if (MekanismUtils.canFunction(this) && this.delayTicks == 0) {
            Direction direction = this.getDirection();
            TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(direction.func_176734_d()));
            TileEntity front = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
            if (InventoryUtils.isItemHandler(back, direction) && front != null) {
                TransitRequest request;
                TransitRequest.TransitResponse response;
                boolean sentItems = false;
                for (SorterFilter<?> filter : this.filters) {
                    int min;
                    TransitRequest.TransitResponse response2;
                    TransitRequest request2 = filter.mapInventory(back, direction, this.singleItem);
                    if (request2.isEmpty() || (response2 = this.emitItemToTransporter(front, request2, filter.color, min = this.singleItem ? 1 : (filter.sizeMode ? filter.min : 0))).isEmpty()) continue;
                    response2.useAll();
                    WorldUtils.saveChunk(back);
                    this.setActive(true);
                    sentItems = true;
                    break;
                }
                if (!sentItems && this.autoEject && !(response = this.emitItemToTransporter(front, request = TransitRequest.definedItem(back, direction, this.singleItem ? 1 : 64, this.strictFinder), this.color, 0)).isEmpty()) {
                    response.useAll();
                    WorldUtils.saveChunk(back);
                    this.setActive(true);
                }
            }
            this.delayTicks = 10;
        }
    }

    private TransitRequest.TransitResponse emitItemToTransporter(TileEntity front, TransitRequest request, EnumColor filterColor, int min) {
        if (front instanceof TileEntityLogisticalTransporterBase) {
            LogisticalTransporterBase transporter = ((TileEntityLogisticalTransporterBase)front).getTransmitter();
            if (this.roundRobin) {
                return transporter.insertRR(this, request, filterColor, true, min);
            }
            return transporter.insert((TileEntity)this, request, filterColor, true, min);
        }
        return request.addToInventory(front, this.getDirection(), min, false);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.rrTarget != null) {
            nbtTags.func_218657_a("rrTarget", (INBT)this.rrTarget.serialize());
        }
        return nbtTags;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        if (nbtTags.func_150297_b("rrTarget", 10)) {
            this.rrTarget = SidedBlockPos.deserialize(nbtTags.func_74775_l("rrTarget"));
        }
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markDirty(false);
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markDirty(false);
    }

    @ComputerMethod(nameOverride="getAutoMode")
    public boolean getAutoEject() {
        return this.autoEject;
    }

    @ComputerMethod(nameOverride="isRoundRobin")
    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    @ComputerMethod(nameOverride="isSingle")
    public boolean getSingleItem() {
        return this.singleItem;
    }

    public void toggleAutoEject() {
        this.autoEject = !this.autoEject;
        this.markDirty(false);
    }

    public void toggleRoundRobin() {
        this.roundRobin = !this.roundRobin;
        this.rrTarget = null;
        this.markDirty(false);
    }

    public void toggleSingleItem() {
        this.singleItem = !this.singleItem;
        this.markDirty(false);
    }

    public void changeColor(@Nullable EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.markDirty(false);
        }
    }

    public boolean canSendHome(ItemStack stack) {
        Direction oppositeDirection = this.getOppositeDirection();
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(oppositeDirection));
        return TransporterUtils.canInsert(back, null, stack, oppositeDirection, true);
    }

    public boolean hasConnectedInventory() {
        Direction oppositeDirection = this.getOppositeDirection();
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(oppositeDirection));
        return TransporterUtils.isValidAcceptorOnSide(tile, oppositeDirection);
    }

    @Nonnull
    public TransitRequest.TransitResponse sendHome(TransitRequest request) {
        Direction oppositeDirection = this.getOppositeDirection();
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(oppositeDirection));
        return request.addToInventory(back, oppositeDirection, 0, true);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        data.func_74757_a("eject", this.autoEject);
        data.func_74757_a("roundRobin", this.roundRobin);
        data.func_74757_a("singleItem", this.singleItem);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (SorterFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            data.func_218657_a("filters", (INBT)filterTags);
        }
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setEnumIfPresent(data, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        this.autoEject = data.func_74767_n("eject");
        this.roundRobin = data.func_74767_n("roundRobin");
        this.singleItem = data.func_74767_n("singleItem");
        this.filters.clear();
        if (data.func_150297_b("filters", 9)) {
            ListNBT tagList = data.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof SorterFilter)) continue;
                this.filters.add((SorterFilter)filter);
            }
        }
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "color", TransporterUtils.getColorIndex(this.color));
        ItemDataUtils.setBoolean(itemStack, "eject", this.autoEject);
        ItemDataUtils.setBoolean(itemStack, "roundRobin", this.roundRobin);
        ItemDataUtils.setBoolean(itemStack, "singleItem", this.singleItem);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (SorterFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "color", 3)) {
            this.color = TransporterUtils.readColor(ItemDataUtils.getInt(itemStack, "color"));
        }
        this.autoEject = ItemDataUtils.getBoolean(itemStack, "eject");
        this.roundRobin = ItemDataUtils.getBoolean(itemStack, "roundRobin");
        this.singleItem = ItemDataUtils.getBoolean(itemStack, "singleItem");
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof SorterFilter)) continue;
                this.filters.add((SorterFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("color", "color");
        remap.put("eject", "eject");
        remap.put("roundRobin", "roundRobin");
        remap.put("singleItem", "singleItem");
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public int getRedstoneLevel() {
        return this.getActive() ? 15 : 0;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    @Override
    @ComputerMethod
    public HashList<SorterFilter<?>> getFilters() {
        return this.filters;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getAutoEject, value -> {
            this.autoEject = value;
        }));
        container.track(SyncableBoolean.create(this::getRoundRobin, value -> {
            this.roundRobin = value;
        }));
        container.track(SyncableBoolean.create(this::getSingleItem, value -> {
            this.singleItem = value;
        }));
        container.track(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.color), value -> {
            this.color = TransporterUtils.readColor(value);
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    @ComputerMethod
    private void setSingle(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.singleItem != value) {
            this.toggleSingleItem();
        }
    }

    @ComputerMethod
    private void setRoundRobin(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.roundRobin != value) {
            this.toggleRoundRobin();
        }
    }

    @ComputerMethod
    private void setAutoMode(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.autoEject != value) {
            this.toggleAutoEject();
        }
    }

    @ComputerMethod
    private void clearDefaultColor() throws ComputerException {
        this.validateSecurityIsPublic();
        this.changeColor(null);
    }

    @ComputerMethod
    private void incrementDefaultColor() throws ComputerException {
        this.validateSecurityIsPublic();
        this.color = TransporterUtils.increment(this.color);
        this.markDirty(false);
    }

    @ComputerMethod
    private void decrementDefaultColor() throws ComputerException {
        this.validateSecurityIsPublic();
        this.color = TransporterUtils.decrement(this.color);
        this.markDirty(false);
    }

    @ComputerMethod
    private void setDefaultColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        if (!TransporterUtils.colors.contains(color)) {
            throw new ComputerException("Color '%s' is not a supported transporter color.", color);
        }
        this.changeColor(color);
    }

    @ComputerMethod
    private boolean addFilter(SorterFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.add(filter);
    }

    @ComputerMethod
    private boolean removeFilter(SorterFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.remove(filter);
    }
}

