/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;

public class LaserParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<LaserParticleData> DESERIALIZER = new IParticleData.IDeserializer<LaserParticleData>(){

        @Nonnull
        public LaserParticleData fromCommand(@Nonnull ParticleType<LaserParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            Direction direction = Direction.func_82600_a((int)reader.readInt());
            reader.expect(' ');
            double distance = reader.readDouble();
            reader.expect(' ');
            float energyScale = reader.readFloat();
            return new LaserParticleData(direction, distance, energyScale);
        }

        @Nonnull
        public LaserParticleData fromNetwork(@Nonnull ParticleType<LaserParticleData> type, PacketBuffer buf) {
            return new LaserParticleData((Direction)buf.func_179257_a(Direction.class), buf.readDouble(), buf.readFloat());
        }
    };
    public static final Codec<LaserParticleData> CODEC = RecordCodecBuilder.create(val -> val.group((App)MekanismUtils.DIRECTION_CODEC.fieldOf("direction").forGetter(data -> data.direction), (App)Codec.DOUBLE.fieldOf("distance").forGetter(data -> data.distance), (App)Codec.FLOAT.fieldOf("energyScale").forGetter(data -> Float.valueOf(data.energyScale))).apply((Applicative)val, LaserParticleData::new));
    public final Direction direction;
    public final double distance;
    public final float energyScale;

    public LaserParticleData(Direction direction, double distance, float energyScale) {
        this.direction = direction;
        this.distance = distance;
        this.energyScale = energyScale;
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return MekanismParticleTypes.LASER.getParticleType();
    }

    public void func_197553_a(@Nonnull PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.direction);
        buffer.writeDouble(this.distance);
        buffer.writeFloat(this.energyScale);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %d %.2f %.2f", this.func_197554_b().getRegistryName(), this.direction.ordinal(), this.distance, Float.valueOf(this.energyScale));
    }
}

