/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.robit.RobitSkin;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.entity.EntityRobit;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PacketRobit
implements IMekanismPacket {
    private static final Map<String, List<IRobitSkinProvider>> EASTER_EGGS = ImmutableMap.builder().put((Object)"sara", Arrays.asList(MekanismRobitSkins.LESBIAN, MekanismRobitSkins.TRANS)).build();
    private final RobitPacketType activeType;
    private final int entityId;
    private final String name;
    private final RobitSkin skin;

    public PacketRobit(RobitPacketType type, EntityRobit robit) {
        this(type, robit.func_145782_y(), null, null);
    }

    public PacketRobit(EntityRobit robit, @Nonnull String name) {
        this(RobitPacketType.NAME, robit, name, null);
    }

    public PacketRobit(EntityRobit robit, @Nonnull RobitSkin skin) {
        this(RobitPacketType.SKIN, robit, null, skin);
    }

    private PacketRobit(RobitPacketType type, EntityRobit robit, @Nullable String name, @Nullable RobitSkin skin) {
        this(type, robit.func_145782_y(), name, skin);
    }

    private PacketRobit(RobitPacketType type, int entityId, @Nullable String name, @Nullable RobitSkin skin) {
        this.activeType = type;
        this.entityId = entityId;
        this.name = name;
        this.skin = skin;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        EntityRobit robit;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (robit = (EntityRobit)player.field_70170_p.func_73045_a(this.entityId)) != null && SecurityUtils.canAccess((PlayerEntity)player, robit)) {
            if (this.activeType == RobitPacketType.GO_HOME) {
                robit.goHome();
            } else if (this.activeType == RobitPacketType.FOLLOW) {
                robit.setFollowing(!robit.getFollowing());
            } else if (this.activeType == RobitPacketType.DROP_PICKUP) {
                robit.setDropPickup(!robit.getDropPickup());
            } else if (this.activeType == RobitPacketType.NAME) {
                List skins;
                robit.func_200203_b((ITextComponent)TextComponentUtil.getString(this.name));
                if (robit.getSkin() == MekanismRobitSkins.BASE.get() && !(skins = EASTER_EGGS.getOrDefault(this.name.toLowerCase(Locale.ROOT), Collections.emptyList())).isEmpty()) {
                    robit.setSkin((IRobitSkinProvider)skins.get(robit.field_70170_p.field_73012_v.nextInt(skins.size())), null);
                }
            } else if (this.activeType == RobitPacketType.SKIN) {
                robit.setSkin(this.skin, (PlayerEntity)player);
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.activeType);
        buffer.func_150787_b(this.entityId);
        if (this.activeType == RobitPacketType.NAME) {
            buffer.func_180714_a(this.name);
        } else if (this.activeType == RobitPacketType.SKIN) {
            buffer.writeRegistryId((IForgeRegistryEntry)this.skin);
        }
    }

    public static PacketRobit decode(PacketBuffer buffer) {
        RobitPacketType activeType = (RobitPacketType)buffer.func_179257_a(RobitPacketType.class);
        int entityId = buffer.func_150792_a();
        String name = null;
        RobitSkin skin = null;
        if (activeType == RobitPacketType.NAME) {
            name = BasePacketHandler.readString(buffer).trim();
        } else if (activeType == RobitPacketType.SKIN) {
            skin = (RobitSkin)buffer.readRegistryId();
        }
        return new PacketRobit(activeType, entityId, name, skin);
    }

    public static enum RobitPacketType {
        GO_HOME,
        FOLLOW,
        DROP_PICKUP,
        NAME,
        SKIN;

    }
}

