/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketPortableTeleporterTeleport
implements IMekanismPacket {
    private final Frequency.FrequencyIdentity identity;
    private final Hand currentHand;

    public PacketPortableTeleporterTeleport(Hand hand, Frequency.FrequencyIdentity identity) {
        this.currentHand = hand;
        this.identity = identity;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184586_b(this.currentHand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPortableTeleporter) {
            ServerWorld teleWorld;
            TileEntityTeleporter teleporter;
            TeleporterFrequency found = FrequencyType.TELEPORTER.getFrequency(this.identity, player.func_110124_au());
            if (found == null) {
                return;
            }
            Coord4D coords = found.getClosestCoords(new Coord4D((Entity)player));
            if (coords != null && (teleporter = WorldUtils.getTileEntity(TileEntityTeleporter.class, (IBlockReader)(teleWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(coords.dimension)), coords.getPos())) != null) {
                if (!player.func_184812_l_()) {
                    FloatingLong energyCost = TileEntityTeleporter.calculateEnergyCost((Entity)player, coords);
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                    if (energyContainer == null || energyContainer.extract(energyCost, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyCost)) {
                        return;
                    }
                    energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
                }
                try {
                    teleporter.didTeleport.add(player.func_110124_au());
                    teleporter.teleDelay = 5;
                    player.field_71135_a.field_147365_f = 0;
                    player.func_71053_j();
                    Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(player.func_233580_cy_()), player.field_70170_p, coords.getPos());
                    if (player.func_184218_aH()) {
                        player.func_184210_p();
                    }
                    double oldX = player.func_226277_ct_();
                    double oldY = player.func_226278_cu_();
                    double oldZ = player.func_226281_cx_();
                    World oldWorld = player.field_70170_p;
                    BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
                    TileEntityTeleporter.teleportEntityTo((Entity)player, (World)teleWorld, teleporterTargetPos);
                    TileEntityTeleporter.alignPlayer(player, teleporterTargetPos, teleporter);
                    if (player.field_70170_p != oldWorld || player.func_70092_e(oldX, oldY, oldZ) >= 25.0) {
                        oldWorld.func_184148_a(null, oldX, oldY, oldZ, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    teleporter.sendTeleportParticles();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.currentHand);
        FrequencyType.TELEPORTER.getIdentitySerializer().write(buffer, this.identity);
    }

    public static PacketPortableTeleporterTeleport decode(PacketBuffer buffer) {
        return new PacketPortableTeleporterTeleport((Hand)buffer.func_179257_a(Hand.class), FrequencyType.TELEPORTER.getIdentitySerializer().read(buffer));
    }
}

