/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.function.BiConsumer;
import mekanism.api.math.FloatingLong;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGuiSetEnergy
implements IMekanismPacket {
    private final GuiEnergyValue interaction;
    private final BlockPos tilePosition;
    private final FloatingLong value;

    public PacketGuiSetEnergy(GuiEnergyValue interaction, BlockPos tilePosition, FloatingLong value) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.value = value;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, this.tilePosition)) != null) {
            this.interaction.consume(tile, this.value);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.interaction);
        buffer.func_179255_a(this.tilePosition);
        this.value.writeToBuffer(buffer);
    }

    public static PacketGuiSetEnergy decode(PacketBuffer buffer) {
        return new PacketGuiSetEnergy((GuiEnergyValue)buffer.func_179257_a(GuiEnergyValue.class), buffer.func_179259_c(), FloatingLong.readFromBuffer(buffer));
    }

    public static enum GuiEnergyValue {
        MIN_THRESHOLD((tile, value) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                ((TileEntityLaserAmplifier)tile).setMinThresholdFromPacket((FloatingLong)value);
            }
        }),
        MAX_THRESHOLD((tile, value) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                ((TileEntityLaserAmplifier)tile).setMaxThresholdFromPacket((FloatingLong)value);
            }
        }),
        ENERGY_USAGE((tile, value) -> {
            if (tile instanceof TileEntityResistiveHeater) {
                ((TileEntityResistiveHeater)tile).setEnergyUsageFromPacket((FloatingLong)value);
            }
        });

        private final BiConsumer<TileEntityMekanism, FloatingLong> consumerForTile;

        private GuiEnergyValue(BiConsumer<TileEntityMekanism, FloatingLong> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, FloatingLong value) {
            this.consumerForTile.accept(tile, value);
        }
    }
}

