/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.InputValidator;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAddTrusted
implements IMekanismPacket {
    public static final int MAX_NAME_LENGTH = 16;
    private final BlockPos tilePosition;
    private final String name;

    public PacketAddTrusted(BlockPos tilePosition, String name) {
        this.tilePosition = tilePosition;
        this.name = name;
    }

    public static boolean validateNameLength(int length) {
        return length >= 3 && length <= 16;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntitySecurityDesk tile;
        ServerPlayerEntity player;
        if (!this.name.isEmpty() && InputValidator.test(this.name, InputValidator.USERNAME) && (player = context.getSender()) != null && (tile = WorldUtils.getTileEntity(TileEntitySecurityDesk.class, (IBlockReader)player.field_70170_p, this.tilePosition)) != null) {
            tile.addTrusted(this.name);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.tilePosition);
        buffer.func_211400_a(this.name, 16);
    }

    public static PacketAddTrusted decode(PacketBuffer buffer) {
        return new PacketAddTrusted(buffer.func_179259_c(), buffer.func_150789_c(16));
    }
}

