/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import java.util.function.BooleanSupplier;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketLightningRender
implements IMekanismPacket {
    private final LightningPreset preset;
    private final Vector3d start;
    private final Vector3d end;
    private final int renderer;
    private final int segments;

    public PacketLightningRender(LightningPreset preset, int renderer, Vector3d start, Vector3d end, int segments) {
        this.preset = preset;
        this.renderer = renderer;
        this.start = start;
        this.end = end;
        this.segments = segments;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.preset.shouldAdd.getAsBoolean()) {
            RenderTickHandler.renderBolt(this.renderer, this.preset.boltCreator.create(this.start, this.end, this.segments));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.preset);
        buffer.func_150787_b(this.renderer);
        BasePacketHandler.writeVector3d(buffer, this.start);
        BasePacketHandler.writeVector3d(buffer, this.end);
        buffer.func_150787_b(this.segments);
    }

    public static PacketLightningRender decode(PacketBuffer buffer) {
        LightningPreset preset = (LightningPreset)buffer.func_179257_a(LightningPreset.class);
        int renderer = buffer.func_150792_a();
        Vector3d start = BasePacketHandler.readVector3d(buffer);
        Vector3d end = BasePacketHandler.readVector3d(buffer);
        int segments = buffer.func_150792_a();
        return new PacketLightningRender(preset, renderer, start, end, segments);
    }

    public static enum LightningPreset {
        MAGNETIC_ATTRACTION(MekanismConfig.client.renderMagneticAttractionParticles, (start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.04f).lifespan(8).spawn(BoltEffect.SpawnFunction.noise(8.0f, 4.0f))),
        TOOL_AOE(MekanismConfig.client.renderToolAOEParticles, (start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.015f).lifespan(12).spawn(BoltEffect.SpawnFunction.NO_DELAY));

        private final BooleanSupplier shouldAdd;
        private final BoltCreator boltCreator;

        private LightningPreset(BooleanSupplier shouldAdd, BoltCreator boltCreator) {
            this.shouldAdd = shouldAdd;
            this.boltCreator = boltCreator;
        }
    }

    @FunctionalInterface
    public static interface BoltCreator {
        public BoltEffect create(Vector3d var1, Vector3d var2, int var3);
    }
}

