/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.fluid.IExtendedFluidHandler;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.merged.GaugeDropperContentsHandler;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemGaugeDropper
extends Item {
    public ItemGaugeDropper(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        if (!fluidStack.isEmpty()) {
            if (fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204547_b)) {
                return -2397415;
            }
            return fluidStack.getFluid().getAttributes().getColor(fluidStack);
        }
        return ChemicalUtil.getRGBDurabilityForDisplay(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                IFluidHandlerItem fluidHandler;
                Optional fluidCapability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
                if (fluidCapability.isPresent() && (fluidHandler = (IFluidHandlerItem)fluidCapability.get()) instanceof IExtendedFluidHandler) {
                    IExtendedFluidHandler fluidHandlerItem = (IExtendedFluidHandler)fluidHandler;
                    for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                        fluidHandlerItem.setFluidInTank(tank, FluidStack.EMPTY);
                    }
                }
                ItemGaugeDropper.clearChemicalTanks(stack, GasStack.EMPTY);
                ItemGaugeDropper.clearChemicalTanks(stack, InfusionStack.EMPTY);
                ItemGaugeDropper.clearChemicalTanks(stack, PigmentStack.EMPTY);
                ItemGaugeDropper.clearChemicalTanks(stack, SlurryStack.EMPTY);
                ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void clearChemicalTanks(ItemStack stack, STACK empty) {
        Optional cap = stack.getCapability(ChemicalUtil.getCapabilityForChemical(empty)).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                handler.setChemicalInTank(tank, empty);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        StorageUtils.addStoredSubstance(stack, tooltip, false);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, GaugeDropperContentsHandler.create());
    }
}

