/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CraftingWindowInventorySlot
extends BasicInventorySlot {
    protected final QIOCraftingWindow craftingWindow;
    @Nullable
    private final IContentsListener inputTypeChange;
    private ItemStack lastCurrent = ItemStack.field_190927_a;
    private boolean wasEmpty = true;

    public static CraftingWindowInventorySlot input(QIOCraftingWindow window, @Nullable IContentsListener saveListener) {
        return new CraftingWindowInventorySlot(notExternal, alwaysTrueBi, window, saveListener, window);
    }

    protected CraftingWindowInventorySlot(BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert, QIOCraftingWindow craftingWindow, @Nullable IContentsListener saveListener, @Nullable IContentsListener inputTypeChange) {
        super(canExtract, canInsert, (Predicate<ItemStack>)alwaysTrue, saveListener, 0, 0);
        this.craftingWindow = craftingWindow;
        this.inputTypeChange = inputTypeChange;
    }

    @Override
    @Nonnull
    public VirtualInventoryContainerSlot createContainerSlot() {
        return new VirtualInventoryContainerSlot(this, this.craftingWindow.getWindowData(), this.getSlotOverlay(), this::setStackUnchecked);
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.inputTypeChange != null && (this.current.func_190926_b() != this.wasEmpty || this.current != this.lastCurrent && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.current, (ItemStack)this.lastCurrent))) {
            this.lastCurrent = this.current;
            this.wasEmpty = this.current.func_190926_b();
            this.inputTypeChange.onContentsChanged();
        }
    }
}

