/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.ArmorSlot;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IHasExtraData;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.slot.OffhandSlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBlockPos;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloat;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.sync.SyncableShort;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.container.sync.chemical.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.chemical.SyncablePigmentStack;
import mekanism.common.inventory.container.sync.chemical.SyncableSlurryStack;
import mekanism.common.inventory.container.sync.list.SyncableList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.network.to_client.container.PacketUpdateContainer;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_server.PacketWindowSelect;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class MekanismContainer
extends Container
implements ISecurityContainer {
    public static final int BASE_Y_OFFSET = 84;
    public static final int TRANSPORTER_CONFIG_WINDOW = 0;
    public static final int SIDE_CONFIG_WINDOW = 1;
    public static final int UPGRADE_WINDOW = 2;
    public static final int SKIN_SELECT_WINDOW = 3;
    protected final PlayerInventory inv;
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<ArmorSlot> armorSlots = new ArrayList<ArmorSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    protected final List<OffhandSlot> offhandSlots = new ArrayList<OffhandSlot>();
    private final List<ISyncableData> trackedData = new ArrayList<ISyncableData>();
    private final Map<Object, List<ISyncableData>> specificTrackedData = new Object2ObjectOpenHashMap();
    @Nullable
    protected SelectedWindowData selectedWindow;
    private Map<UUID, SelectedWindowData> selectedWindows;

    protected MekanismContainer(ContainerTypeRegistryObject<?> type, int id, PlayerInventory inv) {
        super(type.getContainerType(), id);
        this.inv = inv;
        if (!this.isRemote()) {
            this.selectedWindows = new HashMap<UUID, SelectedWindowData>(1);
        }
    }

    public boolean isRemote() {
        return this.inv.field_70458_d.field_70170_p.field_72995_K;
    }

    public UUID getPlayerUUID() {
        return this.inv.field_70458_d.func_110124_au();
    }

    @Nonnull
    protected Slot func_75146_a(@Nonnull Slot slot) {
        slot.field_75222_d = this.field_75151_b.size();
        this.field_75151_b.add(slot);
        this.track(SyncableItemStack.create(() -> ((Slot)slot).func_75211_c(), arg_0 -> ((Slot)slot).func_75215_d(arg_0)));
        if (slot instanceof IHasExtraData) {
            ((IHasExtraData)slot).addTrackers(this.inv.field_70458_d, this::track);
        }
        if (slot instanceof InventoryContainerSlot) {
            this.inventoryContainerSlots.add((InventoryContainerSlot)slot);
        } else if (slot instanceof ArmorSlot) {
            this.armorSlots.add((ArmorSlot)slot);
        } else if (slot instanceof MainInventorySlot) {
            this.mainInventorySlots.add((MainInventorySlot)slot);
        } else if (slot instanceof HotBarSlot) {
            this.hotBarSlots.add((HotBarSlot)slot);
        } else if (slot instanceof OffhandSlot) {
            this.offhandSlots.add((OffhandSlot)slot);
        }
        return slot;
    }

    protected void addSlotsAndOpen() {
        this.addSlots();
        this.addInventorySlots(this.inv);
        this.openInventory(this.inv);
    }

    public void startTracking(Object key, ISpecificContainerTracker tracker) {
        List<ISyncableData> list = tracker.getSpecificSyncableData();
        list.forEach(this::track);
        this.specificTrackedData.put(key, list);
    }

    public void stopTracking(Object key) {
        List<ISyncableData> list = this.specificTrackedData.get(key);
        if (list != null) {
            list.forEach(this.trackedData::remove);
            this.specificTrackedData.remove(key);
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return true;
    }

    public boolean func_94530_a(@Nonnull ItemStack stack, @Nonnull Slot slot) {
        if (slot instanceof IInsertableSlot) {
            IInsertableSlot insertableSlot = (IInsertableSlot)slot;
            if (!insertableSlot.canMergeWith(stack)) {
                return false;
            }
            SelectedWindowData selectedWindow = this.isRemote() ? this.getSelectedWindow() : this.getSelectedWindow(this.getPlayerUUID());
            return insertableSlot.exists(selectedWindow) && super.func_94530_a(stack, slot);
        }
        return super.func_94530_a(stack, slot);
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        this.closeInventory(player);
    }

    protected void closeInventory(@Nonnull PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            this.clearSelectedWindow(player.func_110124_au());
        }
    }

    protected void openInventory(@Nonnull PlayerInventory inv) {
    }

    protected int getInventoryYOffset() {
        return 84;
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected void addInventorySlots(@Nonnull PlayerInventory inv) {
        if (this instanceof IEmptyContainer) {
            return;
        }
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new MainInventorySlot((IInventory)inv, PlayerInventory.func_70451_h() + slotX + slotY * 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (int slotX = 0; slotX < PlayerInventory.func_70451_h(); ++slotX) {
            this.func_75146_a(this.createHotBarSlot(inv, slotX, xOffset + slotX * 18, yOffset));
        }
    }

    protected void addArmorSlots(@Nonnull PlayerInventory inv, int x, int y, int offhandOffset) {
        for (int index = 0; index < inv.field_70460_b.size(); ++index) {
            EquipmentSlotType slotType = EnumUtils.EQUIPMENT_SLOT_TYPES[2 + inv.field_70460_b.size() - index - 1];
            this.func_75146_a(new ArmorSlot(inv, 36 + inv.field_70460_b.size() - index - 1, x, y, slotType));
            y += 18;
        }
        if (offhandOffset != -1) {
            this.func_75146_a(new OffhandSlot((IInventory)inv, 40, x, y + offhandOffset));
        }
    }

    protected HotBarSlot createHotBarSlot(@Nonnull PlayerInventory inv, int index, int x, int y) {
        return new HotBarSlot((IInventory)inv, index, x, y);
    }

    protected void addSlots() {
    }

    public List<InventoryContainerSlot> getInventoryContainerSlots() {
        return Collections.unmodifiableList(this.inventoryContainerSlots);
    }

    public List<MainInventorySlot> getMainInventorySlots() {
        return Collections.unmodifiableList(this.mainInventorySlots);
    }

    public List<HotBarSlot> getHotBarSlots() {
        return Collections.unmodifiableList(this.hotBarSlots);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotID) {
        ItemStack slotStack;
        SelectedWindowData selectedWindow;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot == null || !currentSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        SelectedWindowData selectedWindowData = selectedWindow = player.field_70170_p.field_72995_K ? this.getSelectedWindow() : this.getSelectedWindow(player.func_110124_au());
        if (currentSlot instanceof IInsertableSlot && !((IInsertableSlot)currentSlot).exists(selectedWindow)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackToInsert = slotStack = currentSlot.func_75211_c();
        if (currentSlot instanceof InventoryContainerSlot) {
            stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, false, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, false, selectedWindow);
        } else {
            stackToInsert = MekanismContainer.insertItem(this.inventoryContainerSlots, stackToInsert, true, selectedWindow);
            if (slotStack.func_190916_E() == stackToInsert.func_190916_E()) {
                stackToInsert = MekanismContainer.insertItem(this.inventoryContainerSlots, stackToInsert, false, selectedWindow);
                if (slotStack.func_190916_E() == stackToInsert.func_190916_E()) {
                    if (currentSlot instanceof ArmorSlot || currentSlot instanceof OffhandSlot) {
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, true, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, true, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, false, selectedWindow);
                    } else if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, selectedWindow);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, selectedWindow);
                    }
                }
            }
        }
        if (stackToInsert.func_190916_E() == slotStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, @Nullable SelectedWindowData selectedWindow) {
        stack = MekanismContainer.insertItem(slots, stack, true, selectedWindow);
        return MekanismContainer.insertItem(slots, stack, false, selectedWindow);
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, @Nullable SelectedWindowData selectedWindow) {
        return MekanismContainer.insertItem(slots, stack, ignoreEmpty, selectedWindow, Action.EXECUTE);
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, @Nullable SelectedWindowData selectedWindow, Action action) {
        return MekanismContainer.insertItem(slots, stack, ignoreEmpty, false, selectedWindow, action);
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItemCheckAll(List<SLOT> slots, @Nonnull ItemStack stack, @Nullable SelectedWindowData selectedWindow, Action action) {
        return MekanismContainer.insertItem(slots, stack, false, true, selectedWindow, action);
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, boolean checkAll, @Nullable SelectedWindowData selectedWindow, Action action) {
        if (stack.func_190926_b()) {
            return stack;
        }
        for (Slot slot : slots) {
            if (!checkAll && ignoreEmpty != slot.func_75216_d() || !((IInsertableSlot)slot).exists(selectedWindow) || !(stack = ((IInsertableSlot)slot).insertItem(stack, action)).func_190926_b()) continue;
            break;
        }
        return stack;
    }

    @Nonnull
    protected ItemStack transferSuccess(@Nonnull Slot currentSlot, @Nonnull PlayerEntity player, @Nonnull ItemStack slotStack, @Nonnull ItemStack stackToInsert) {
        int difference = slotStack.func_190916_E() - stackToInsert.func_190916_E();
        currentSlot.func_75209_a(difference);
        ItemStack newStack = StackUtils.size(slotStack, difference);
        currentSlot.func_190901_a(player, newStack);
        return newStack;
    }

    @Nullable
    public SelectedWindowData getSelectedWindow() {
        return this.selectedWindow;
    }

    @Nullable
    public SelectedWindowData getSelectedWindow(UUID player) {
        return this.selectedWindows.get(player);
    }

    public void setSelectedWindow(@Nullable SelectedWindowData selectedWindow) {
        if (!Objects.equals(this.selectedWindow, selectedWindow)) {
            this.selectedWindow = selectedWindow;
            Mekanism.packetHandler.sendToServer(new PacketWindowSelect(this.selectedWindow));
        }
    }

    public void setSelectedWindow(UUID player, @Nullable SelectedWindowData selectedWindow) {
        if (selectedWindow == null) {
            this.clearSelectedWindow(player);
        } else {
            this.selectedWindows.put(player, selectedWindow);
        }
    }

    private void clearSelectedWindow(UUID player) {
        this.selectedWindows.remove(player);
    }

    public void track(ISyncableData data) {
        this.trackedData.add(data);
    }

    @Nonnull
    protected IntReferenceHolder func_216958_a(@Nonnull IntReferenceHolder referenceHolder) {
        this.track(SyncableInt.create(() -> ((IntReferenceHolder)referenceHolder).func_221495_b(), arg_0 -> ((IntReferenceHolder)referenceHolder).func_221494_a(arg_0)));
        return referenceHolder;
    }

    public void trackArray(boolean[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableBoolean.create(arrayIn, i));
        }
    }

    public void trackArray(byte[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableByte.create(arrayIn, i));
        }
    }

    public void trackArray(double[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableDouble.create(arrayIn, i));
        }
    }

    public void trackArray(float[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableFloat.create(arrayIn, i));
        }
    }

    public void trackArray(int[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableInt.create(arrayIn, i));
        }
    }

    public void trackArray(long[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableLong.create(arrayIn, i));
        }
    }

    public void trackArray(short[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableShort.create(arrayIn, i));
        }
    }

    public void handleWindowProperty(short property, boolean value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableBoolean) {
            ((SyncableBoolean)data).set(value);
        }
    }

    public void handleWindowProperty(short property, byte value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableByte) {
            ((SyncableByte)data).set(value);
        }
    }

    public void handleWindowProperty(short property, short value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableShort) {
            ((SyncableShort)data).set(value);
        } else if (data instanceof SyncableFloatingLong) {
            ((SyncableFloatingLong)data).setDecimal(value);
        }
    }

    public void handleWindowProperty(short property, int value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableInt) {
            ((SyncableInt)data).set(value);
        } else if (data instanceof SyncableEnum) {
            ((SyncableEnum)data).set(value);
        } else if (data instanceof SyncableFluidStack) {
            ((SyncableFluidStack)data).set(value);
        } else if (data instanceof SyncableItemStack) {
            ((SyncableItemStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, long value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableLong) {
            ((SyncableLong)data).set(value);
        } else if (data instanceof SyncableChemicalStack) {
            ((SyncableChemicalStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, float value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFloat) {
            ((SyncableFloat)data).set(value);
        }
    }

    public void handleWindowProperty(short property, double value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableDouble) {
            ((SyncableDouble)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull ItemStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableItemStack) {
            ((SyncableItemStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull FluidStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFluidStack) {
            ((SyncableFluidStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nullable BlockPos value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableBlockPos) {
            ((SyncableBlockPos)data).set(value);
        }
    }

    public <V extends IForgeRegistryEntry<V>> void handleWindowProperty(short property, @Nonnull V value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableRegistryEntry) {
            ((SyncableRegistryEntry)data).set(value);
        }
    }

    public <STACK extends ChemicalStack<?>> void handleWindowProperty(short property, @Nonnull STACK value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableGasStack && value instanceof GasStack) {
            ((SyncableGasStack)data).set((GasStack)value);
        } else if (data instanceof SyncableInfusionStack && value instanceof InfusionStack) {
            ((SyncableInfusionStack)data).set((InfusionStack)value);
        } else if (data instanceof SyncablePigmentStack && value instanceof PigmentStack) {
            ((SyncablePigmentStack)data).set((PigmentStack)value);
        } else if (data instanceof SyncableSlurryStack && value instanceof SlurryStack) {
            ((SyncableSlurryStack)data).set((SlurryStack)value);
        }
    }

    public <FREQUENCY extends Frequency> void handleWindowProperty(short property, @Nullable FREQUENCY value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFrequency) {
            ((SyncableFrequency)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull FloatingLong value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFloatingLong) {
            ((SyncableFloatingLong)data).set(value);
        }
    }

    public <TYPE> void handleWindowProperty(short property, @Nonnull List<TYPE> value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableList) {
            ((SyncableList)data).set(value);
        }
    }

    public void func_75142_b() {
        if (!this.field_75149_d.isEmpty()) {
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            for (short i = 0; i < this.trackedData.size(); i = (short)(i + 1)) {
                ISyncableData data = this.trackedData.get(i);
                ISyncableData.DirtyType dirtyType = data.isDirty();
                if (dirtyType == ISyncableData.DirtyType.CLEAN) continue;
                dirtyData.add(data.getPropertyData(i, dirtyType));
            }
            if (!dirtyData.isEmpty()) {
                this.sendChange(new PacketUpdateContainer((short)this.field_75152_c, dirtyData));
            }
        }
    }

    private <MSG> void sendChange(MSG packet) {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            Mekanism.packetHandler.sendTo(packet, (ServerPlayerEntity)listener);
        }
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        boolean alreadyHas = this.field_75149_d.contains(listener);
        super.func_75132_a(listener);
        if (!alreadyHas && listener instanceof ServerPlayerEntity) {
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            for (short i = 0; i < this.trackedData.size(); i = (short)(i + 1)) {
                dirtyData.add(this.trackedData.get(i).getPropertyData(i, ISyncableData.DirtyType.DIRTY));
            }
            if (!dirtyData.isEmpty()) {
                Mekanism.packetHandler.sendTo(new PacketUpdateContainer((short)this.field_75152_c, dirtyData), (ServerPlayerEntity)listener);
            }
        }
    }

    public static interface ISpecificContainerTracker {
        public List<ISyncableData> getSpecificSyncableData();
    }
}

