/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content.attribute.gas;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.crafttweaker.content.attribute.CrTChemicalAttribute;
import mekanism.common.integration.crafttweaker.content.attribute.ICrTChemicalAttribute;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.content.attribute.gas.FuelAttribute")
public class CrTFuelAttribute
extends CrTChemicalAttribute
implements ICrTChemicalAttribute.ICrTGasAttribute {
    @ZenCodeType.Method
    public static CrTFuelAttribute create(int burnTicks, FloatingLong energyDensity) {
        if (burnTicks <= 0) {
            throw new IllegalArgumentException("Fuel attributes must burn for at least one tick! Burn Ticks: " + burnTicks);
        }
        if (energyDensity.isZero()) {
            throw new IllegalArgumentException("Fuel attributes must have an energy density greater than zero!");
        }
        FloatingLong density = energyDensity.copyAsConst();
        return new CrTFuelAttribute(new GasAttributes.Fuel(() -> burnTicks, () -> density));
    }

    protected CrTFuelAttribute(GasAttributes.Fuel attribute) {
        super(attribute);
    }
}

