/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class ModuleSolarRechargingUnit
implements ICustomModule<ModuleSolarRechargingUnit> {
    private static final FloatingLong RAIN_MULTIPLIER = FloatingLong.createConst(0.2);

    @Override
    public void tickServer(IModule<ModuleSolarRechargingUnit> module, PlayerEntity player) {
        BlockPos pos;
        IEnergyContainer energyContainer = module.getEnergyContainer();
        if (energyContainer != null && !energyContainer.getNeeded().isZero() && WorldUtils.canSeeSun(player.field_70170_p, pos = new BlockPos(player.func_226277_ct_(), player.func_226280_cw_() + 0.2, player.func_226281_cx_()))) {
            Biome b = player.field_70170_p.func_225523_d_().func_226836_a_(pos);
            boolean needsRainCheck = b.func_201851_b() != Biome.RainType.NONE;
            float tempEff = 0.3f * (0.8f - b.func_225486_c(pos));
            float humidityEff = needsRainCheck ? -0.3f * b.func_76727_i() : 0.0f;
            FloatingLong peakOutput = ((FloatingLong)MekanismConfig.gear.mekaSuitSolarRechargingRate.get()).multiply(1.0f + tempEff + humidityEff);
            float brightness = WorldUtils.getSunBrightness(player.field_70170_p, 1.0f);
            FloatingLong production = peakOutput.multiply(brightness);
            if (needsRainCheck && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I())) {
                production = production.timesEqual(RAIN_MULTIPLIER);
            }
            energyContainer.insert(production.multiply(module.getInstalledCount()), Action.EXECUTE, AutomationType.MANUAL);
        }
    }
}

