/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ISustainedInventory;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockMekanism
extends Block {
    protected BlockMekanism(AbstractBlock.Properties properties) {
        super(BlockStateHelper.applyLightLevelAdjustments(properties));
        this.func_180632_j(BlockStateHelper.getDefaultState((BlockState)this.field_176227_L.func_177621_b()));
    }

    @Nonnull
    @Deprecated
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        if (this.hasTileEntity(state)) {
            return PushReaction.BLOCK;
        }
        return super.func_149656_h(state);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, world, pos);
        if (tile == null) {
            return itemStack;
        }
        Item item = itemStack.func_77973_b();
        if (tile.getFrequencyComponent().hasCustomFrequencies()) {
            tile.getFrequencyComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (item instanceof ISecurityItem && tile.hasSecurity()) {
            ISecurityItem securityItem = (ISecurityItem)item;
            securityItem.setOwnerUUID(itemStack, tile.getOwnerUUID());
            securityItem.setSecurity(itemStack, tile.getSecurityMode());
        }
        if (tile.supportsUpgrades()) {
            tile.getComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tile);
            config.getConfig().write(ItemDataUtils.getDataMap(itemStack));
            config.getEjector().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tile instanceof ISustainedData) {
            ((ISustainedData)((Object)tile)).writeSustainedData(itemStack);
        }
        if (tile.supportsRedstone()) {
            ItemDataUtils.setInt(itemStack, "controlType", tile.getControlType().ordinal());
        }
        for (SubstanceType type : EnumUtils.SUBSTANCES) {
            if (!tile.handles(type)) continue;
            ItemDataUtils.setList(itemStack, type.getContainerTag(), DataHandlerUtils.writeContainers(type.getContainers(tile)));
        }
        if (item instanceof ISustainedInventory && tile.persistInventory() && tile.getSlots() > 0) {
            ((ISustainedInventory)item).setInventory(tile.getInventory(new Object[0]), itemStack);
        }
        return itemStack;
    }

    @Nonnull
    @Deprecated
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        TileEntityMekanism mekTile;
        TileEntity tile;
        List drops = super.func_220076_a(state, builder);
        if (state.func_177230_c() instanceof IHasTileEntity && (tile = ((IHasTileEntity)state.func_177230_c()).getTileType().func_200968_a()) instanceof TileEntityMekanism && !(mekTile = (TileEntityMekanism)tile).getGasTanks(null).isEmpty() && (!(mekTile instanceof TileEntityChemicalTank) || ((TileEntityChemicalTank)mekTile).getTier() != ChemicalTankTier.CREATIVE)) {
            for (ItemStack drop : drops) {
                ListNBT gasTankList = ItemDataUtils.getList(drop, "GasTanks");
                if (gasTankList.isEmpty()) continue;
                int count = DataHandlerUtils.getMaxId(gasTankList, "Tank");
                ArrayList<IGasTank> tanks = new ArrayList<IGasTank>(count);
                for (int i = 0; i < count; ++i) {
                    tanks.add(ChemicalTankBuilder.GAS.createDummy(Long.MAX_VALUE));
                }
                DataHandlerUtils.readContainers(tanks, gasTankList);
                boolean hasRadioactive = false;
                for (IGasTank tank : tanks) {
                    if (tank.isEmpty() || !((GasStack)tank.getStack()).has(GasAttributes.Radiation.class)) continue;
                    hasRadioactive = true;
                    tank.setEmpty();
                }
                if (!hasRadioactive) continue;
                ListNBT newGasTankList = DataHandlerUtils.writeContainers(tanks);
                if (newGasTankList.isEmpty()) {
                    ItemDataUtils.removeData(drop, "GasTanks");
                    continue;
                }
                ItemDataUtils.setList(drop, "GasTanks", newGasTankList);
            }
        }
        return drops;
    }

    public boolean hasTileEntity(BlockState state) {
        return this instanceof IHasTileEntity;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        if (this instanceof IHasTileEntity) {
            return ((IHasTileEntity)((Object)this)).getTileType().func_200968_a();
        }
        return null;
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        BlockStateHelper.fillBlockStateContainer(this, builder);
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        return BlockStateHelper.getStateForPlacement(this, super.func_196258_a(context), context);
    }

    @Nonnull
    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        if (state.func_177230_c() instanceof IStateFluidLoggable) {
            return ((IStateFluidLoggable)state.func_177230_c()).getFluid(state);
        }
        return super.func_204507_t(state);
    }

    @Nonnull
    @Deprecated
    public BlockState func_196271_a(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (state.func_177230_c() instanceof IStateFluidLoggable) {
            ((IStateFluidLoggable)state.func_177230_c()).updateFluids(state, world, currentPos);
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos);
        if (tile == null) {
            return;
        }
        if (tile.supportsRedstone()) {
            tile.redstone = world.func_175640_z(pos);
        }
        tile.onPlace();
        Item item = stack.func_77973_b();
        this.setTileData(world, pos, state, placer, stack, tile);
        if (!world.field_72995_K && tile.getFrequencyComponent().hasCustomFrequencies()) {
            tile.getFrequencyComponent().read(ItemDataUtils.getDataMap(stack));
        }
        if (tile instanceof TileEntitySecurityDesk && placer != null) {
            tile.getSecurity().setOwnerUUID(placer.func_110124_au());
        }
        if (item instanceof ISecurityItem && tile.hasSecurity()) {
            ISecurityItem securityItem = (ISecurityItem)item;
            tile.setSecurityMode(securityItem.getSecurity(stack));
            UUID ownerUUID = securityItem.getOwnerUUID(stack);
            if (ownerUUID != null) {
                tile.getSecurity().setOwnerUUID(ownerUUID);
            } else if (placer != null) {
                tile.getSecurity().setOwnerUUID(placer.func_110124_au());
                if (!world.field_72995_K) {
                    Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate(placer.func_110124_au(), null));
                }
            }
        }
        if (tile.supportsUpgrades()) {
            tile.getComponent().read(ItemDataUtils.getDataMap(stack));
        }
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tile);
            config.getConfig().read(ItemDataUtils.getDataMap(stack));
            config.getEjector().read(ItemDataUtils.getDataMap(stack));
        }
        for (SubstanceType type : EnumUtils.SUBSTANCES) {
            if (!type.canHandle(tile)) continue;
            DataHandlerUtils.readContainers(type.getContainers(tile), ItemDataUtils.getList(stack, type.getContainerTag()));
        }
        if (tile instanceof ISustainedData && stack.func_77942_o()) {
            ((ISustainedData)((Object)tile)).readSustainedData(stack);
        }
        if (tile.supportsRedstone() && ItemDataUtils.hasData(stack, "controlType", 3)) {
            tile.setControlType(IRedstoneControl.RedstoneControl.byIndexStatic(ItemDataUtils.getInt(stack, "controlType")));
        }
        if (item instanceof ISustainedInventory && tile.persistInventory()) {
            tile.setInventory(((ISustainedInventory)item).getInventory(stack), new Object[0]);
        }
    }

    public void setTileData(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, TileEntityMekanism tile) {
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return AttributeStateFacing.rotate(state, world, pos, rotation);
    }

    @Nonnull
    @Deprecated
    public BlockState func_185499_a(@Nonnull BlockState state, @Nonnull Rotation rotation) {
        return AttributeStateFacing.rotate(state, rotation);
    }

    @Nonnull
    @Deprecated
    public BlockState func_185471_a(@Nonnull BlockState state, @Nonnull Mirror mirror) {
        return AttributeStateFacing.mirror(state, mirror);
    }

    @Deprecated
    public void func_220082_b(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        TileEntityMekanism tile;
        if (state.hasTileEntity() && oldState.func_177230_c() != state.func_177230_c() && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos)) != null) {
            tile.onAdded();
        }
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    @Deprecated
    public boolean func_149740_M(@Nonnull BlockState blockState) {
        return Attribute.has(this, Attributes.AttributeComparator.class);
    }

    @Deprecated
    public int func_180641_l(@Nonnull BlockState blockState, @Nonnull World world, @Nonnull BlockPos pos) {
        IComparatorSupport comparatorTile;
        TileEntity tile;
        if (this.func_149740_M(blockState) && (tile = WorldUtils.getTileEntity((IBlockReader)world, pos)) instanceof IComparatorSupport && (comparatorTile = (IComparatorSupport)tile).supportsComparator()) {
            return comparatorTile.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Deprecated
    public float func_180647_a(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return this.getDestroyProgress(state, player, world, pos, this.hasTileEntity(state) ? WorldUtils.getTileEntity(world, pos) : null);
    }

    protected float getDestroyProgress(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable TileEntity tile) {
        float speed = super.func_180647_a(state, player, world, pos);
        if (tile instanceof ITileRadioactive && ((ITileRadioactive)tile).getRadiationScale() > 0.0f) {
            return speed / 5.0f;
        }
        return speed;
    }

    public void func_180655_c(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random random) {
        int count;
        super.func_180655_c(state, world, pos, random);
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
        if (tile instanceof ITileRadioactive && (count = ((ITileRadioactive)tile).getRadiationParticleCount()) > 0) {
            count = random.nextInt(count);
            for (int i = 0; i < count; ++i) {
                double randX = (double)pos.func_177958_n() - 0.1 + random.nextDouble() * 1.2;
                double randY = (double)pos.func_177956_o() - 0.1 + random.nextDouble() * 1.2;
                double randZ = (double)pos.func_177952_p() - 0.1 + random.nextDouble() * 1.2;
                world.func_195594_a((IParticleData)MekanismParticleTypes.RADIATION.getParticleType(), randX, randY, randZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        state.func_196954_c((IBlockReader)world, pos).func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double xDif = Math.min(1.0, maxX - minX);
            double yDif = Math.min(1.0, maxY - minY);
            double zDif = Math.min(1.0, maxZ - minZ);
            int xCount = MathHelper.func_76143_f((double)(xDif / 0.25));
            int yCount = MathHelper.func_76143_f((double)(yDif / 0.25));
            int zCount = MathHelper.func_76143_f((double)(zDif / 0.25));
            if (xCount > 0 && yCount > 0 && zCount > 0) {
                for (int x = 0; x < xCount; ++x) {
                    for (int y = 0; y < yCount; ++y) {
                        for (int z = 0; z < zCount; ++z) {
                            double d4 = ((double)x + 0.5) / (double)xCount;
                            double d5 = ((double)y + 0.5) / (double)yCount;
                            double d6 = ((double)z + 0.5) / (double)zCount;
                            double d7 = d4 * xDif + minX;
                            double d8 = d5 * yDif + minY;
                            double d9 = d6 * zDif + minZ;
                            manager.func_78873_a((Particle)new DiggingParticle((ClientWorld)world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                        }
                    }
                }
            }
        });
        return true;
    }

    protected ActionResultType genericClientActivated(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (Attribute.has(this, AttributeGui.class) || MekanismUtils.canUseAsWrench(player.func_184586_b(hand))) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

