/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
public class RenderTeleporter
extends MekanismTileEntityRenderer<TileEntityTeleporter> {
    private static final Map<Direction, MekanismRenderer.Model3D> modelCache = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);
    private static final Map<Direction, MekanismRenderer.Model3D> rotatedModelCache = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);

    public static void resetCachedModels() {
        modelCache.clear();
        rotatedModelCache.clear();
    }

    public RenderTeleporter(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityTeleporter tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.shouldRender && tile.func_145831_w() != null) {
            MekanismRenderer.renderObject(this.getOverlayModel(tile.frameDirection(), tile.frameRotated()), matrix, renderer.getBuffer(Atlases.func_228785_j_()), MekanismRenderer.getColorARGB(tile.getColor(), 0.75f), 0xF000F0, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
        }
    }

    @Override
    protected String getProfilerSection() {
        return "teleporter";
    }

    private MekanismRenderer.Model3D getOverlayModel(@Nullable Direction direction, boolean rotated) {
        Map<Direction, MekanismRenderer.Model3D> cache;
        if (direction == null) {
            direction = Direction.UP;
        }
        Map<Direction, MekanismRenderer.Model3D> map = cache = rotated ? rotatedModelCache : modelCache;
        if (!cache.containsKey(direction)) {
            MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
            model.setTexture(MekanismRenderer.teleporterPortal);
            cache.put(direction, model);
            if (direction == Direction.UP) {
                model.minY = 1.0f;
                model.maxY = 3.0f;
                this.setUpDownDimensions(model, rotated);
            } else if (direction == Direction.DOWN) {
                model.minY = -2.0f;
                model.maxY = 0.0f;
                this.setUpDownDimensions(model, rotated);
            } else if (direction == Direction.EAST) {
                model.minX = 1.0f;
                model.maxX = 3.0f;
                this.setEastWestDimensions(model, rotated);
            } else if (direction == Direction.WEST) {
                model.minX = -2.0f;
                model.maxX = 0.0f;
                this.setEastWestDimensions(model, rotated);
            } else if (direction == Direction.NORTH) {
                model.minZ = -2.0f;
                model.maxZ = 0.0f;
                this.setNorthSouthDimensions(model, rotated);
            } else if (direction == Direction.SOUTH) {
                model.minZ = 0.0f;
                model.maxZ = 3.0f;
                this.setNorthSouthDimensions(model, rotated);
            }
        }
        return cache.get(direction);
    }

    private void setUpDownDimensions(MekanismRenderer.Model3D model, boolean rotated) {
        if (rotated) {
            model.minX = 0.46f;
            model.maxX = 0.54f;
            model.minZ = 0.0f;
            model.maxZ = 1.0f;
        } else {
            model.minX = 0.0f;
            model.maxX = 1.0f;
            model.minZ = 0.46f;
            model.maxZ = 0.54f;
        }
    }

    private void setEastWestDimensions(MekanismRenderer.Model3D model, boolean rotated) {
        if (rotated) {
            model.minY = 0.46f;
            model.maxY = 0.54f;
            model.minZ = 0.0f;
            model.maxZ = 1.0f;
        } else {
            model.minY = 0.0f;
            model.maxY = 1.0f;
            model.minZ = 0.46f;
            model.maxZ = 0.54f;
        }
    }

    private void setNorthSouthDimensions(MekanismRenderer.Model3D model, boolean rotated) {
        if (rotated) {
            model.minY = 0.46f;
            model.maxY = 0.54f;
            model.minX = 0.0f;
            model.maxX = 1.0f;
        } else {
            model.minY = 0.0f;
            model.maxY = 1.0f;
            model.minX = 0.46f;
            model.maxX = 0.54f;
        }
    }

    public boolean shouldRenderOffScreen(TileEntityTeleporter tile) {
        return tile.shouldRender && tile.func_145831_w() != null;
    }
}

