/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.client.render.obj.TransmitterModelConfiguration;
import mekanism.client.render.obj.TransmitterModelTransform;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.obj.OBJModel;

public class TransmitterBakedModel
implements IBakedModel {
    private final OBJModel internal;
    @Nullable
    private final OBJModel glass;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private final IModelTransform modelTransform;
    private final ItemOverrideList overrides;
    private final ResourceLocation modelLocation;
    private final IBakedModel bakedVariant;
    private final Map<QuickHash, List<BakedQuad>> modelCache;

    public TransmitterBakedModel(OBJModel internal, @Nullable OBJModel glass, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.modelCache = new Object2ObjectOpenHashMap(glass == null ? 4096 : 8192);
        this.internal = internal;
        this.glass = glass;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
        this.modelLocation = modelLocation;
        List<String> visible = Arrays.stream(EnumUtils.DIRECTIONS).map(side -> side.func_176742_j() + (side.func_176740_k() == Direction.Axis.Y ? "NORMAL" : "NONE")).collect(Collectors.toList());
        this.bakedVariant = internal.bake((IModelConfiguration)new VisibleModelConfiguration(owner, visible), bakery, spriteGetter, modelTransform, overrides, modelLocation);
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return Collections.emptyList();
        }
        if (extraData.hasProperty(TileEntityTransmitter.TRANSMITTER_PROPERTY)) {
            TransmitterModelData data = (TransmitterModelData)extraData.getData(TileEntityTransmitter.TRANSMITTER_PROPERTY);
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            boolean hasColor = data.getHasColor() && layer == RenderType.func_228645_f_();
            QuickHash hash = new QuickHash(data.getConnectionsMap(), hasColor);
            if (!this.modelCache.containsKey(hash)) {
                ArrayList<String> visible = new ArrayList<String>();
                for (Direction dir : EnumUtils.DIRECTIONS) {
                    visible.add(dir.func_176610_l() + data.getConnectionType(dir).func_176610_l().toUpperCase(Locale.ROOT));
                }
                List result = this.bake(new TransmitterModelConfiguration(this.owner, visible, extraData), hasColor).getQuads(state, null, rand, extraData);
                this.modelCache.put(hash, result);
                return result;
            }
            return this.modelCache.get(hash);
        }
        return this.bakedVariant.getQuads(state, null, rand, extraData);
    }

    private IBakedModel bake(TransmitterModelConfiguration configuration, boolean hasColor) {
        TextureAtlasSprite particle = this.spriteGetter.apply(configuration.resolveTexture("particle"));
        IModelBuilder builder = IModelBuilder.of((IModelConfiguration)configuration, (ItemOverrideList)this.overrides, (TextureAtlasSprite)particle);
        this.addPartQuads(configuration, builder, this.internal);
        if (this.glass != null && hasColor && MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_()) {
            this.addPartQuads(configuration, builder, this.glass);
        }
        return builder.build();
    }

    private void addPartQuads(TransmitterModelConfiguration configuration, IModelBuilder<?> builder, OBJModel glass) {
        for (IModelGeometryPart part : glass.getParts()) {
            if (!configuration.getPartVisibility(part)) continue;
            String name = part.name();
            IModelTransform transform = this.modelTransform;
            if (name.endsWith("NONE")) {
                Direction dir = TransmitterBakedModel.directionForPiece(name);
                TransmitterModelConfiguration.IconStatus status = configuration.getIconStatus(dir);
                if (dir != null && status.getAngle() > 0.0f) {
                    transform = new TransmitterModelTransform(transform, dir, status.getAngle());
                }
            }
            part.addQuads((IModelConfiguration)configuration, builder, this.bakery, this.spriteGetter, transform, this.modelLocation);
        }
    }

    @Nullable
    private static Direction directionForPiece(@Nonnull String piece) {
        return Arrays.stream(EnumUtils.DIRECTIONS).filter(dir -> piece.startsWith(dir.func_176742_j())).findFirst().orElse(null);
    }

    public boolean func_177555_b() {
        return this.bakedVariant.func_177555_b();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.bakedVariant.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.bakedVariant.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.bakedVariant.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.bakedVariant.func_188618_c();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite func_177554_e() {
        return this.bakedVariant.func_177554_e();
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.bakedVariant.getParticleTexture(data);
    }

    public boolean doesHandlePerspectives() {
        return this.bakedVariant.doesHandlePerspectives();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this.bakedVariant.handlePerspective(cameraTransformType, mat);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.bakedVariant.func_188617_f();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return this.bakedVariant.getModelData(world, pos, state, tileData);
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.bakedVariant.func_177552_f();
    }

    public static class QuickHash {
        private final Object[] objs;

        public QuickHash(Object ... objs) {
            this.objs = objs;
        }

        public int hashCode() {
            return Arrays.hashCode(this.objs);
        }

        public Object[] get() {
            return this.objs;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QuickHash && Arrays.deepEquals(this.objs, ((QuickHash)obj).objs);
        }
    }
}

