/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.BaseTier;
import mekanism.client.SpecialColors;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.model.baked.DigitalMinerBakedModel;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.ValveRenderData;
import mekanism.client.render.item.block.RenderFluidTankItem;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.client.render.tileentity.RenderDigitalMiner;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderNutritionalLiquifier;
import mekanism.client.render.tileentity.RenderPigmentMixer;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="mekanism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MekanismRenderer {
    public static final int FULL_LIGHT = 0xF000F0;
    public static final int FULL_SKY_LIGHT = LightTexture.func_228451_a_((int)0, (int)15);
    public static OBJModel contentsModel;
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite whiteIcon;
    public static TextureAtlasSprite teleporterPortal;
    public static TextureAtlasSprite redstoneTorch;
    public static TextureAtlasSprite redstonePulse;
    public static final Map<TransmissionType, TextureAtlasSprite> overlays;

    public static TextureAtlasSprite getBaseFluidTexture(@Nonnull Fluid fluid, @Nonnull FluidType type) {
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture() : fluid.getAttributes().getFlowingTexture();
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack fluidStack, @Nonnull FluidType type) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture(fluidStack) : fluid.getAttributes().getFlowingTexture(fluidStack);
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getChemicalTexture(@Nonnull Chemical<?> chemical) {
        return MekanismRenderer.getSprite(chemical.getIcon());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(spriteLocation);
    }

    public static void prepFlowing(Model3D model, @Nonnull FluidStack fluid) {
        Model3D.SpriteInfo still = new Model3D.SpriteInfo(MekanismRenderer.getFluidTexture(fluid, FluidType.STILL), 16);
        Model3D.SpriteInfo flowing = new Model3D.SpriteInfo(MekanismRenderer.getFluidTexture(fluid, FluidType.FLOWING), 8);
        model.setTextures(still, still, flowing, flowing, flowing, flowing);
    }

    public static void prepSingleFaceModelSize(Model3D model, Direction face) {
        switch (face) {
            case DOWN: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = -0.01f;
                model.maxY = -0.001f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
                break;
            }
            case UP: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = 1.001f;
                model.maxY = 1.01f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
                break;
            }
            case NORTH: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = -0.01f;
                model.maxZ = -0.001f;
                break;
            }
            case SOUTH: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = 1.001f;
                model.maxZ = 1.01f;
                break;
            }
            case WEST: {
                model.minX = -0.01f;
                model.maxX = -0.001f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
                break;
            }
            case EAST: {
                model.minX = 1.001f;
                model.maxX = 1.01f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
            }
        }
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull MatrixStack matrix, IVertexBuilder buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay) {
        MekanismRenderer.renderObject(object, matrix, buffer, argb, light, overlay, faceDisplay, true);
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull MatrixStack matrix, IVertexBuilder buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, boolean fakeDisableDiffuse) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, argb, light, overlay, faceDisplay, fakeDisableDiffuse);
        }
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull MatrixStack matrix, IVertexBuilder buffer, int[] colors, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, colors, light, overlay, faceDisplay, true);
        }
    }

    public static void renderValves(MatrixStack matrix, IVertexBuilder buffer, Set<IValveHandler.ValveData> valves, FluidRenderData data, BlockPos pos, int glow, int overlay, BooleanSupplier inMultiblock) {
        if (!valves.isEmpty()) {
            RenderResizableCuboid.FaceDisplay faceDisplay = inMultiblock.getAsBoolean() ? RenderResizableCuboid.FaceDisplay.BOTH : RenderResizableCuboid.FaceDisplay.FRONT;
            for (IValveHandler.ValveData valveData : valves) {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(valveData.location.func_177958_n() - pos.func_177958_n()), (double)(valveData.location.func_177956_o() - pos.func_177956_o()), (double)(valveData.location.func_177952_p() - pos.func_177952_p()));
                MekanismRenderer.renderObject(ModelRenderer.getValveModel(ValveRenderData.get(data, valveData)), matrix, buffer, data.getColorARGB(), glow, overlay, faceDisplay);
                matrix.func_227865_b_();
            }
        }
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void resetColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.color4f((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)MekanismRenderer.getAlpha(color));
    }

    public static void color(ColorAtlas.ColorRegistryObject colorRO) {
        MekanismRenderer.color(colorRO.get());
    }

    public static void color(Color color) {
        RenderSystem.color4f((float)color.rf(), (float)color.gf(), (float)color.bf(), (float)color.af());
    }

    public static void color(@Nonnull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            MekanismRenderer.color(fluid.getFluid().getAttributes().getColor(fluid));
        }
    }

    public static void color(@Nonnull ChemicalStack<?> chemicalStack) {
        if (!chemicalStack.isEmpty()) {
            MekanismRenderer.color(chemicalStack.getType());
        }
    }

    public static void color(@Nonnull Chemical<?> chemical) {
        if (!chemical.isEmptyType()) {
            int color = chemical.getTint();
            RenderSystem.color3f((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color));
        }
    }

    public static void color(@Nonnull BaseTier tier) {
        MekanismRenderer.color(tier.getColor());
    }

    public static void color(@Nullable EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha) {
        if (color != null) {
            RenderSystem.color4f((float)color.getColor(0), (float)color.getColor(1), (float)color.getColor(2), (float)alpha);
        }
    }

    public static int getColorARGB(EnumColor color, float alpha) {
        return MekanismRenderer.getColorARGB(color.getRgbCode()[0], color.getRgbCode()[1], color.getRgbCode()[2], alpha);
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack) {
        return fluidStack.getFluid().getAttributes().getColor(fluidStack);
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = MekanismRenderer.getColorARGB(fluidStack);
        if (fluidStack.getFluid().getAttributes().isGaseous(fluidStack)) {
            return MekanismRenderer.getColorARGB(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), Math.min(1.0f, fluidScale + 0.2f));
        }
        return color;
    }

    public static int getColorARGB(@Nonnull ChemicalStack<?> stack, float scale, boolean gaseous) {
        if (stack.isEmpty()) {
            return -1;
        }
        int color = stack.getChemicalTint();
        return MekanismRenderer.getColorARGB(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), gaseous ? Math.min(1.0f, scale + 0.2f) : 1.0f);
    }

    public static int getColorARGB(float red, float green, float blue, float alpha) {
        return MekanismRenderer.getColorARGB((int)(255.0f * red), (int)(255.0f * green), (int)(255.0f * blue), alpha);
    }

    public static int getColorARGB(int red, int green, int blue, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        int argb = (int)(255.0f * alpha) << 24;
        argb |= red << 16;
        argb |= green << 8;
        return argb |= blue;
    }

    public static int calculateGlowLight(int combinedLight, @Nonnull FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : MekanismRenderer.calculateGlowLight(combinedLight, fluid.getFluid().getAttributes().getLuminosity(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static void renderColorOverlay(MatrixStack matrix, int x, int y, int width, int height, int color) {
        float r = MekanismRenderer.getRed(color);
        float g = MekanismRenderer.getGreen(color);
        float b = MekanismRenderer.getBlue(color);
        float a = MekanismRenderer.getAlpha(color);
        RenderSystem.disableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(matrix4f, (float)width, (float)y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)x, (float)y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)x, (float)height, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)width, (float)height, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
    }

    public static float getPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    public static void rotate(MatrixStack matrix, Direction facing, float north, float south, float west, float east) {
        switch (facing) {
            case NORTH: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(north));
                break;
            }
            case SOUTH: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(south));
                break;
            }
            case WEST: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(west));
                break;
            }
            case EAST: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(east));
            }
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        try {
            contentsModel = OBJLoader.INSTANCE.loadModel(new OBJModel.ModelSettings(RenderTransmitterBase.MODEL_LOCATION, true, false, true, true, null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            event.addSprite(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay"));
        }
        event.addSprite(Mekanism.rl("block/overlay/overlay_white"));
        event.addSprite(Mekanism.rl("liquid/energy"));
        event.addSprite(Mekanism.rl("liquid/heat"));
        event.addSprite(Mekanism.rl("icon/redstone_control_pulse"));
        event.addSprite(Mekanism.rl("block/teleporter_portal"));
        event.addSprite(Mekanism.rl("entity/armor/blank"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_player"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_body"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_helmet"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_exoskeleton"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_gravitational_modulator"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_elytra"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_modules"));
        event.addSprite(Mekanism.rl("entity/armor/mekatool"));
        DigitalMinerBakedModel.preStitch(event);
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.gasRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.infuseTypeRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.pigmentRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.slurryRegistry());
        ModelRenderer.resetCachedModels();
        RenderDigitalMiner.resetCachedVisuals();
        RenderFluidTank.resetCachedModels();
        RenderFluidTankItem.resetCachedModels();
        RenderNutritionalLiquifier.resetCachedModels();
        RenderPigmentMixer.resetCached();
        RenderMechanicalPipe.onStitch();
        RenderTickHandler.resetCached();
        RenderTeleporter.resetCachedModels();
        MekanismRenderer.parseColorAtlas(Mekanism.rl("textures/colormap/primary.png"));
        SpecialColors.GUI_OBJECTS.parse(Mekanism.rl("textures/colormap/gui_objects.png"));
        SpecialColors.GUI_TEXT.parse(Mekanism.rl("textures/colormap/gui_text.png"));
        GuiElementHolder.updateBackgroundColor();
    }

    private static void parseColorAtlas(ResourceLocation rl) {
        List<Color> parsed = ColorAtlas.load(rl, EnumUtils.COLORS.length);
        if (parsed.size() < EnumUtils.COLORS.length) {
            Mekanism.logger.error("Failed to parse primary color atlas.");
            return;
        }
        for (int i = 0; i < EnumUtils.COLORS.length; ++i) {
            EnumUtils.COLORS[i].setColorFromAtlas(parsed.get(i).rgbArray());
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>> void addChemicalSprites(TextureStitchEvent.Pre event, IForgeRegistry<CHEMICAL> chemicalRegistry) {
        for (Chemical chemical : chemicalRegistry.getValues()) {
            event.addSprite(chemical.getIcon());
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post event) {
        AtlasTexture map = event.getMap();
        if (!map.func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            overlays.put(type, map.func_195424_a(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay")));
        }
        whiteIcon = map.func_195424_a(Mekanism.rl("block/overlay/overlay_white"));
        energyIcon = map.func_195424_a(Mekanism.rl("liquid/energy"));
        heatIcon = map.func_195424_a(Mekanism.rl("liquid/heat"));
        redstoneTorch = map.func_195424_a(new ResourceLocation("minecraft:block/redstone_torch"));
        redstonePulse = map.func_195424_a(Mekanism.rl("icon/redstone_control_pulse"));
        teleporterPortal = map.func_195424_a(Mekanism.rl("block/teleporter_portal"));
        DigitalMinerBakedModel.onStitch(event);
        RenderLogisticalTransporter.onStitch(map);
        RenderTransmitterBase.onStitch();
    }

    static {
        overlays = new EnumMap<TransmissionType, TextureAtlasSprite>(TransmissionType.class);
    }

    public static class Model3D {
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        private final SpriteInfo[] textures = new SpriteInfo[6];
        private final boolean[] renderSides = new boolean[]{true, true, true, true, true, true};

        public void setSideRender(Direction side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public Model3D copy() {
            Model3D copy = new Model3D();
            System.arraycopy(this.textures, 0, copy.textures, 0, this.textures.length);
            System.arraycopy(this.renderSides, 0, copy.renderSides, 0, this.renderSides.length);
            copy.minX = this.minX;
            copy.minY = this.minY;
            copy.minZ = this.minZ;
            copy.maxX = this.maxX;
            copy.maxY = this.maxY;
            copy.maxZ = this.maxZ;
            return copy;
        }

        @Nullable
        public SpriteInfo getSpriteToRender(Direction side) {
            int ordinal = side.ordinal();
            if (this.renderSides[ordinal]) {
                return this.textures[ordinal];
            }
            return null;
        }

        public void setTexture(Direction side, SpriteInfo spriteInfo) {
            this.textures[side.ordinal()] = spriteInfo;
        }

        public void setTexture(TextureAtlasSprite tex) {
            this.setTexture(tex, 16);
        }

        public void setTexture(TextureAtlasSprite tex, int size) {
            Arrays.fill(this.textures, new SpriteInfo(tex, size));
        }

        public void setTextures(SpriteInfo down, SpriteInfo up, SpriteInfo north, SpriteInfo south, SpriteInfo west, SpriteInfo east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }

        public static final class SpriteInfo {
            public final TextureAtlasSprite sprite;
            public final int size;

            public SpriteInfo(TextureAtlasSprite sprite, int size) {
                this.sprite = sprite;
                this.size = size;
            }
        }
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

