/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.JEIColorDetails;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class PaintingRecipeCategory
extends BaseRecipeCategory<PaintingRecipe> {
    private final Map<PaintingRecipe, IGuiIngredientGroup<PigmentStack>> ingredients = new WeakHashMap<PaintingRecipe, IGuiIngredientGroup<PigmentStack>>();
    private final PigmentColorDetails colorDetails;
    private final GuiGauge<?> inputPigment;
    private final GuiSlot inputSlot = this.addSlot(SlotType.INPUT, 45, 35);
    private final GuiSlot output;

    public PaintingRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.PAINTING_MACHINE, 25, 13, 146, 60);
        this.addSlot(SlotType.POWER, 144, 35).with(SlotOverlay.POWER);
        this.output = this.addSlot(SlotType.OUTPUT, 116, 35);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, FULL_BAR, 164, 15));
        this.inputPigment = this.addElement(GuiPigmentGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 25, 13));
        this.colorDetails = new PigmentColorDetails();
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 64, 39).colored(this.colorDetails);
    }

    public Class<? extends PaintingRecipe> getRecipeClass() {
        return PaintingRecipe.class;
    }

    @Override
    public void draw(PaintingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IGuiIngredientGroup<PigmentStack> group = this.ingredients.get(recipe);
        if (group != null) {
            this.colorDetails.ingredient = (IGuiIngredient)group.getGuiIngredients().get(0);
        }
        super.draw(recipe, matrixStack, mouseX, mouseY);
        this.colorDetails.ingredient = null;
    }

    public void setIngredients(PaintingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
        ingredients.setInputLists(MekanismJEI.TYPE_PIGMENT, Collections.singletonList(((PigmentStackIngredient)recipe.getChemicalInput()).getRepresentations()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PaintingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 0, true, this.inputSlot, recipe.getItemInput().getRepresentations());
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 1, false, this.output, recipe.getOutputDefinition());
        IGuiIngredientGroup pigmentStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_PIGMENT);
        this.initChemical(pigmentStacks, 0, true, this.inputPigment, ((PigmentStackIngredient)recipe.getChemicalInput()).getRepresentations());
        this.ingredients.put(recipe, (IGuiIngredientGroup<PigmentStack>)pigmentStacks);
    }

    private static class PigmentColorDetails
    extends JEIColorDetails<Pigment, PigmentStack> {
        @Nullable
        private IGuiIngredient<PigmentStack> ingredient;

        private PigmentColorDetails() {
            super(PigmentStack.EMPTY);
        }

        @Override
        public int getColorFrom() {
            return this.getColor(this.ingredient);
        }

        @Override
        public int getColorTo() {
            return -1;
        }
    }
}

