/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ModuleData;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IItemProvider;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.robit.GuiRobitRepair;
import mekanism.client.jei.CatalystRegistryHelper;
import mekanism.client.jei.ChemicalStackHelper;
import mekanism.client.jei.ChemicalStackRenderer;
import mekanism.client.jei.FormulaicRecipeTransferInfo;
import mekanism.client.jei.GhostIngredientHandler;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.QIOCraftingTransferHandler;
import mekanism.client.jei.machine.BoilerRecipeCategory;
import mekanism.client.jei.machine.ChemicalCrystallizerRecipeCategory;
import mekanism.client.jei.machine.ChemicalDissolutionRecipeCategory;
import mekanism.client.jei.machine.ChemicalInfuserRecipeCategory;
import mekanism.client.jei.machine.CombinerRecipeCategory;
import mekanism.client.jei.machine.ElectrolysisRecipeCategory;
import mekanism.client.jei.machine.FluidSlurryToSlurryRecipeCategory;
import mekanism.client.jei.machine.FluidToFluidRecipeCategory;
import mekanism.client.jei.machine.GasToGasRecipeCategory;
import mekanism.client.jei.machine.ItemStackGasToItemStackRecipeCategory;
import mekanism.client.jei.machine.ItemStackToEnergyRecipeCategory;
import mekanism.client.jei.machine.ItemStackToGasRecipeCategory;
import mekanism.client.jei.machine.ItemStackToInfuseTypeRecipeCategory;
import mekanism.client.jei.machine.ItemStackToItemStackRecipeCategory;
import mekanism.client.jei.machine.ItemStackToPigmentRecipeCategory;
import mekanism.client.jei.machine.MetallurgicInfuserRecipeCategory;
import mekanism.client.jei.machine.NucleosynthesizingRecipeCategory;
import mekanism.client.jei.machine.PaintingRecipeCategory;
import mekanism.client.jei.machine.PigmentMixerRecipeCategory;
import mekanism.client.jei.machine.PressurizedReactionRecipeCategory;
import mekanism.client.jei.machine.RotaryCondensentratorRecipeCategory;
import mekanism.client.jei.machine.SPSRecipeCategory;
import mekanism.client.jei.machine.SawmillRecipeCategory;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.entity.robit.CraftingRobitContainer;
import mekanism.common.inventory.container.item.PortableQIODashboardContainer;
import mekanism.common.inventory.container.tile.QIODashboardContainer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistry;

@JeiPlugin
public class MekanismJEI
implements IModPlugin {
    public static final IIngredientType<GasStack> TYPE_GAS = () -> GasStack.class;
    public static final IIngredientType<InfusionStack> TYPE_INFUSION = () -> InfusionStack.class;
    public static final IIngredientType<PigmentStack> TYPE_PIGMENT = () -> PigmentStack.class;
    public static final IIngredientType<SlurryStack> TYPE_SLURRY = () -> SlurryStack.class;
    public static final ChemicalStackHelper.GasStackHelper GAS_STACK_HELPER = new ChemicalStackHelper.GasStackHelper();
    public static final ChemicalStackHelper.InfusionStackHelper INFUSION_STACK_HELPER = new ChemicalStackHelper.InfusionStackHelper();
    public static final ChemicalStackHelper.PigmentStackHelper PIGMENT_STACK_HELPER = new ChemicalStackHelper.PigmentStackHelper();
    public static final ChemicalStackHelper.SlurryStackHelper SLURRY_STACK_HELPER = new ChemicalStackHelper.SlurryStackHelper();
    private static final ResourceLocation ENERGY_CONVERSION = Mekanism.rl("energy_conversion");
    private static final ResourceLocation GAS_CONVERSION = Mekanism.rl("gas_conversion");
    private static final ResourceLocation INFUSION_CONVERSION = Mekanism.rl("infusion_conversion");
    private static final IIngredientSubtypeInterpreter<ItemStack> MEKANISM_NBT_INTERPRETER = (stack, context) -> {
        if (context == UidContext.Ingredient && stack.func_77942_o()) {
            String nbtRepresentation = MekanismJEI.getChemicalComponent(stack, Capabilities.GAS_HANDLER_CAPABILITY);
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getChemicalComponent(stack, Capabilities.INFUSION_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getChemicalComponent(stack, Capabilities.PIGMENT_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getChemicalComponent(stack, Capabilities.SLURRY_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getFluidComponent(stack));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getEnergyComponent(stack));
            return nbtRepresentation;
        }
        return "";
    };

    private static String addInterpretation(String nbtRepresentation, String component) {
        return nbtRepresentation.isEmpty() ? component : nbtRepresentation + ":" + component;
    }

    private static String getChemicalComponent(ItemStack stack, Capability<? extends IChemicalHandler<?, ?>> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                Object chemicalStack = handler.getChemicalInTank(tank);
                if (!((ChemicalStack)chemicalStack).isEmpty()) {
                    component = MekanismJEI.addInterpretation(component, ((ChemicalStack)chemicalStack).getTypeRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getFluidComponent(ItemStack stack) {
        Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (cap.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)cap.get();
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidStack = handler.getFluidInTank(tank);
                if (!fluidStack.isEmpty()) {
                    component = MekanismJEI.addInterpretation(component, fluidStack.getFluid().getRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getEnergyComponent(ItemStack stack) {
        Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)capability.get();
            String component = "";
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                FloatingLong neededEnergy = energyHandlerItem.getNeededEnergy(container);
                if (neededEnergy.isZero()) {
                    component = MekanismJEI.addInterpretation(component, "filled");
                    continue;
                }
                if (containers <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return Mekanism.rl("jei_plugin");
    }

    public static void registerItemSubtypes(ISubtypeRegistration registry, List<? extends IItemProvider> itemProviders) {
        for (IItemProvider iItemProvider : itemProviders) {
            ItemStack itemStack = iItemProvider.getItemStack();
            if (!itemStack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).isPresent() && !FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent()) continue;
            registry.registerSubtypeInterpreter(iItemProvider.getItem(), MEKANISM_NBT_INTERPRETER);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        MekanismJEI.registerItemSubtypes(registry, MekanismItems.ITEMS.getAllItems());
        MekanismJEI.registerItemSubtypes(registry, MekanismBlocks.BLOCKS.getAllBlocks());
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        this.registerIngredientType(registry, MekanismAPI.gasRegistry(), TYPE_GAS, GAS_STACK_HELPER);
        this.registerIngredientType(registry, MekanismAPI.infuseTypeRegistry(), TYPE_INFUSION, INFUSION_STACK_HELPER);
        this.registerIngredientType(registry, MekanismAPI.pigmentRegistry(), TYPE_PIGMENT, PIGMENT_STACK_HELPER);
        this.registerIngredientType(registry, MekanismAPI.slurryRegistry(), TYPE_SLURRY, SLURRY_STACK_HELPER);
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void registerIngredientType(IModIngredientRegistration registry, IForgeRegistry<CHEMICAL> forgeRegistry, IIngredientType<STACK> ingredientType, ChemicalStackHelper<CHEMICAL, STACK> stackHelper) {
        List types = forgeRegistry.getValues().stream().filter(chemical -> !chemical.isEmptyType() && !chemical.isHidden()).map(chemical -> chemical.getStack(1000L)).collect(Collectors.toList());
        stackHelper.setColorHelper(registry.getColorHelper());
        registry.register(ingredientType, types, stackHelper, new ChemicalStackRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalCrystallizerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalDissolutionRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalInfuserRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidSlurryToSlurryRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ElectrolysisRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MetallurgicInfuserRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PressurizedReactionRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToPigmentRecipeCategory(guiHelper, MekanismBlocks.PIGMENT_EXTRACTOR)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PigmentMixerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PaintingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, MekanismBlocks.CHEMICAL_OXIDIZER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, MekanismBlocks.NUTRITIONAL_LIQUIFIER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasToGasRecipeCategory(guiHelper, MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasToGasRecipeCategory(guiHelper, MekanismBlocks.ISOTOPIC_CENTRIFUGE)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CombinerRecipeCategory(guiHelper, MekanismBlocks.COMBINER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, MekanismBlocks.PURIFICATION_CHAMBER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, MekanismBlocks.OSMIUM_COMPRESSOR)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, MekanismBlocks.CHEMICAL_INJECTION_CHAMBER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new NucleosynthesizingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SPSRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BoilerRecipeCategory(guiHelper, MekanismBlocks.BOILER_CASING.getRegistryName())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper, MekanismBlocks.PRECISION_SAWMILL)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, MekanismBlocks.ENRICHMENT_CHAMBER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, MekanismBlocks.CRUSHER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, MekanismBlocks.ENERGIZED_SMELTER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidToFluidRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToEnergyRecipeCategory(guiHelper, ENERGY_CONVERSION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, GAS_CONVERSION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToInfuseTypeRecipeCategory(guiHelper, INFUSION_CONVERSION)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(GuiRobitRepair.class, 102, 48, 22, 15, new ResourceLocation[]{VanillaRecipeCategoryUid.ANVIL});
        registry.addGenericGuiContainerHandler(GuiMekanism.class, (IGuiContainerHandler)new GuiElementHandler());
        registry.addGhostIngredientHandler(GuiMekanism.class, new GhostIngredientHandler());
    }

    /*
     * Exception decompiling
     */
    public void registerRecipes(IRecipeRegistration registry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register(registry, MekanismBlocks.ENRICHMENT_CHAMBER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CRUSHER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.COMBINER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PURIFICATION_CHAMBER, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.OSMIUM_COMPRESSOR, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_INJECTION_CHAMBER, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PRECISION_SAWMILL, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.METALLURGIC_INFUSER, INFUSION_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_CRYSTALLIZER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_INFUSER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_OXIDIZER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_WASHER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ELECTROLYTIC_SEPARATOR, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.SPS_CASING.getRegistryName(), MekanismBlocks.SPS_CASING, MekanismBlocks.SPS_PORT, MekanismBlocks.SUPERCHARGED_COIL);
        CatalystRegistryHelper.register(registry, MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER.getRegistryName(), MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, MekanismBlocks.THERMAL_EVAPORATION_VALVE, MekanismBlocks.THERMAL_EVAPORATION_BLOCK);
        CatalystRegistryHelper.register(registry, MekanismBlocks.BOILER_CASING.getRegistryName(), MekanismBlocks.BOILER_CASING, MekanismBlocks.BOILER_VALVE, MekanismBlocks.PRESSURE_DISPERSER, MekanismBlocks.SUPERHEATING_ELEMENT);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ISOTOPIC_CENTRIFUGE, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.NUTRITIONAL_LIQUIFIER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PIGMENT_EXTRACTOR, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PIGMENT_MIXER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PAINTING_MACHINE, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, GAS_CONVERSION);
        CatalystRegistryHelper.registerCondensentrator(registry);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ENERGIZED_SMELTER, VanillaRecipeCategoryUid.FURNACE);
        CatalystRegistryHelper.registerRecipeItem(registry, MekanismBlocks.FORMULAIC_ASSEMBLICATOR, VanillaRecipeCategoryUid.CRAFTING);
        CatalystRegistryHelper.registerRecipeItem(registry, MekanismItems.ROBIT, MekanismBlocks.ENERGIZED_SMELTER.getRegistryName(), VanillaRecipeCategoryUid.ANVIL, VanillaRecipeCategoryUid.CRAFTING, VanillaRecipeCategoryUid.FURNACE);
        CatalystRegistryHelper.register(registry, ENERGY_CONVERSION, MekanismBlocks.BASIC_ENERGY_CUBE, MekanismBlocks.ADVANCED_ENERGY_CUBE, MekanismBlocks.ELITE_ENERGY_CUBE, MekanismBlocks.ULTIMATE_ENERGY_CUBE);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        IRecipeTransferHandlerHelper transferHelper = registry.getTransferHelper();
        IStackHelper stackHelper = registry.getJeiHelpers().getStackHelper();
        registry.addRecipeTransferHandler(CraftingRobitContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler((IRecipeTransferInfo)new FormulaicRecipeTransferInfo());
        registry.addRecipeTransferHandler(new QIOCraftingTransferHandler<QIODashboardContainer>(transferHelper, stackHelper, QIODashboardContainer.class), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipeTransferHandler(new QIOCraftingTransferHandler<PortableQIODashboardContainer>(transferHelper, stackHelper, PortableQIODashboardContainer.class), VanillaRecipeCategoryUid.CRAFTING);
    }

    private static /* synthetic */ ItemStack lambda$registerRecipes$8(ModuleData data) {
        return data.getItemProvider().getItemStack();
    }
}

