/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MovableFilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.window.filter.qio.GuiQIOItemStackFilter;
import mekanism.client.gui.element.window.filter.qio.GuiQIOModIDFilter;
import mekanism.client.gui.element.window.filter.qio.GuiQIOTagFilter;
import mekanism.client.gui.qio.GuiQIOFilerSelect;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.text.TextUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiQIOFilterHandler<TILE extends TileEntityQIOFilterHandler>
extends GuiMekanismTile<TILE, MekanismTileContainer<TILE>> {
    private static final int FILTER_COUNT = 3;
    private GuiScrollBar scrollBar;

    public GuiQIOFilterHandler(MekanismTileContainer<TILE> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.field_147000_g += 74;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 9, 16, this.field_146999_f - 18, 12, () -> {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            QIOFrequency freq = ((TileEntityQIOFilterHandler)this.tile).getQIOFrequency();
            if (freq == null) {
                list.add(MekanismLang.NO_FREQUENCY.translate(new Object[0]));
            } else {
                list.add(MekanismLang.FREQUENCY.translate(freq.getKey()));
            }
            return list;
        }).tooltip(() -> {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            QIOFrequency freq = ((TileEntityQIOFilterHandler)this.tile).getQIOFrequency();
            if (freq != null) {
                list.add(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity())));
                list.add(MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity())));
            }
            return list;
        }));
        this.func_230480_a_(new GuiElementHolder(this, 9, 30, 144, 68));
        this.func_230480_a_(new GuiElementHolder(this, 9, 98, 144, 22));
        this.func_230480_a_(new TranslationButton(this, 10, 99, 142, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(new GuiQIOFilerSelect(this, (TileEntityQIOFilterHandler)this.tile))));
        this.scrollBar = (GuiScrollBar)this.func_230480_a_(new GuiScrollBar((IGuiWrapper)this, 153, 30, 90, () -> ((TileEntityQIOFilterHandler)this.tile).getFilters().size(), () -> 3));
        for (int i = 0; i < 3; ++i) {
            this.func_230480_a_(new MovableFilterButton(this, 10, 31 + i * 22, 142, 22, i, this.scrollBar::getCurrentSelection, ((TileEntityQIOFilterHandler)this.tile)::getFilters, index -> {
                if (index > 0) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_UP, (TileEntity)this.tile, index));
                }
            }, index -> {
                if (index < ((TileEntityQIOFilterHandler)this.tile).getFilters().size() - 1) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_DOWN, (TileEntity)this.tile, index));
                }
            }, this::onClick, filter -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                if (filter != null) {
                    if (filter instanceof IItemStackFilter) {
                        list.add(((IItemStackFilter)filter).getItemStack());
                    } else if (filter instanceof ITagFilter) {
                        String name = ((ITagFilter)filter).getTagName();
                        if (name != null && !name.isEmpty()) {
                            list.addAll(TagCache.getItemTagStacks(((ITagFilter)filter).getTagName()));
                        }
                    } else if (filter instanceof IModIDFilter) {
                        list.addAll(TagCache.getModIDStacks(((IModIDFilter)filter).getModID(), false));
                    }
                }
                return list;
            }));
        }
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiQIOItemStackFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiQIOTagFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOTagFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiQIOModIDFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOModIDFilter)filter));
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return super.func_231043_a_(mouseX, mouseY, delta) || this.scrollBar.adjustScroll(delta);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

