/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiChemicalBar;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.text.ITextComponent;

public class GuiMergedChemicalBar<HANDLER extends IGasTracker & IInfusionTracker & ISlurryTracker>
extends GuiBar<GuiBar.IBarInfoHandler>
implements IJEIIngredientHelper {
    private final MergedChemicalTank chemicalTank;
    private final GuiChemicalBar<Gas, GasStack> gasBar;
    private final GuiChemicalBar<InfuseType, InfusionStack> infusionBar;
    private final GuiChemicalBar<Pigment, PigmentStack> pigmentBar;
    private final GuiChemicalBar<Slurry, SlurryStack> slurryBar;

    public GuiMergedChemicalBar(IGuiWrapper gui, HANDLER handler, final MergedChemicalTank chemicalTank, int x, int y, int width, int height, boolean horizontal) {
        super(AtlasTexture.field_110575_b, gui, new GuiBar.IBarInfoHandler(){

            @Nullable
            private IChemicalTank<?, ?> getCurrentTank() {
                MergedChemicalTank.Current current = chemicalTank.getCurrent();
                if (current == MergedChemicalTank.Current.EMPTY) {
                    return null;
                }
                if (current == MergedChemicalTank.Current.GAS) {
                    return chemicalTank.getGasTank();
                }
                if (current == MergedChemicalTank.Current.INFUSION) {
                    return chemicalTank.getInfusionTank();
                }
                if (current == MergedChemicalTank.Current.PIGMENT) {
                    return chemicalTank.getPigmentTank();
                }
                if (current == MergedChemicalTank.Current.SLURRY) {
                    return chemicalTank.getSlurryTank();
                }
                throw new IllegalStateException("Unknown current type");
            }

            @Override
            public ITextComponent getTooltip() {
                IChemicalTank<?, ?> currentTank = this.getCurrentTank();
                if (currentTank == null) {
                    return MekanismLang.EMPTY.translate(new Object[0]);
                }
                if (currentTank.getStored() == Long.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(currentTank.getType(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(currentTank.getType(), TextUtils.format(currentTank.getStored()));
            }

            @Override
            public double getLevel() {
                IChemicalTank<?, ?> currentTank = this.getCurrentTank();
                return currentTank == null ? 0.0 : (double)currentTank.getStored() / (double)currentTank.getCapacity();
            }
        }, x, y, width, height, horizontal);
        this.chemicalTank = chemicalTank;
        this.gasBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getGasTank(), handler.getGasTanks(null)), x, y, width, height, horizontal));
        this.infusionBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getInfusionTank(), ((IInfusionTracker)handler).getInfusionTanks(null)), x, y, width, height, horizontal));
        this.pigmentBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getPigmentTank(), ((IPigmentTracker)handler).getPigmentTanks(null)), x, y, width, height, horizontal));
        this.slurryBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getSlurryTank(), ((ISlurryTracker)handler).getSlurryTanks(null)), x, y, width, height, horizontal));
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar == null) {
            super.func_230443_a_(matrix, mouseX, mouseY);
        } else {
            currentBar.func_230443_a_(matrix, mouseX, mouseY);
        }
    }

    @Override
    void drawContentsChecked(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel, boolean warning) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar != null) {
            currentBar.drawContentsChecked(matrix, mouseX, mouseY, partialTicks, handlerLevel, warning);
        }
    }

    @Override
    protected void renderBarOverlay(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel) {
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar == null) {
            return this.gasBar.func_231044_a_(mouseX, mouseY, button) | this.infusionBar.func_231044_a_(mouseX, mouseY, button) | this.pigmentBar.func_231044_a_(mouseX, mouseY, button) | this.slurryBar.func_231044_a_(mouseX, mouseY, button);
        }
        return currentBar.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public Object getIngredient(double mouseX, double mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        return currentBar == null ? null : currentBar.getIngredient(mouseX, mouseY);
    }

    @Nullable
    private GuiChemicalBar<?, ?> getCurrentBarNoFallback() {
        switch (this.chemicalTank.getCurrent()) {
            case GAS: {
                return this.gasBar;
            }
            case INFUSION: {
                return this.infusionBar;
            }
            case PIGMENT: {
                return this.pigmentBar;
            }
            case SLURRY: {
                return this.slurryBar;
            }
        }
        return null;
    }
}

