/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.EmptyGas;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.EmptyInfuseType;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.EmptyPigment;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.EmptySlurry;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.robit.RobitSkin;
import mekanism.api.text.ITooltipHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MekanismAPI {
    public static final String API_VERSION = "10.1.1";
    public static final String MEKANISM_MODID = "mekanism";
    public static boolean debug = false;
    public static final Logger logger = LogManager.getLogger((String)"mekanism_api");
    private static IForgeRegistry<Gas> GAS_REGISTRY;
    private static IForgeRegistry<InfuseType> INFUSE_TYPE_REGISTRY;
    private static IForgeRegistry<Pigment> PIGMENT_REGISTRY;
    private static IForgeRegistry<Slurry> SLURRY_REGISTRY;
    private static IForgeRegistry<ModuleData<?>> MODULE_REGISTRY;
    private static IForgeRegistry<RobitSkin> ROBIT_SKIN_REGISTRY;
    private static IModuleHelper MODULE_HELPER;
    private static IRadiationManager RADIATION_MANAGER;
    private static ITooltipHelper TOOLTIP_HELPER;
    @Nonnull
    public static final Gas EMPTY_GAS;
    @Nonnull
    public static final InfuseType EMPTY_INFUSE_TYPE;
    @Nonnull
    public static final Pigment EMPTY_PIGMENT;
    @Nonnull
    public static final Slurry EMPTY_SLURRY;

    private MekanismAPI() {
    }

    @Nonnull
    public static IForgeRegistry<Gas> gasRegistry() {
        if (GAS_REGISTRY == null) {
            GAS_REGISTRY = RegistryManager.ACTIVE.getRegistry(Gas.class);
        }
        return GAS_REGISTRY;
    }

    @Nonnull
    public static IForgeRegistry<InfuseType> infuseTypeRegistry() {
        if (INFUSE_TYPE_REGISTRY == null) {
            INFUSE_TYPE_REGISTRY = RegistryManager.ACTIVE.getRegistry(InfuseType.class);
        }
        return INFUSE_TYPE_REGISTRY;
    }

    @Nonnull
    public static IForgeRegistry<Pigment> pigmentRegistry() {
        if (PIGMENT_REGISTRY == null) {
            PIGMENT_REGISTRY = RegistryManager.ACTIVE.getRegistry(Pigment.class);
        }
        return PIGMENT_REGISTRY;
    }

    @Nonnull
    public static IForgeRegistry<Slurry> slurryRegistry() {
        if (SLURRY_REGISTRY == null) {
            SLURRY_REGISTRY = RegistryManager.ACTIVE.getRegistry(Slurry.class);
        }
        return SLURRY_REGISTRY;
    }

    @Nonnull
    public static IForgeRegistry<ModuleData<?>> moduleRegistry() {
        if (MODULE_REGISTRY == null) {
            MODULE_REGISTRY = RegistryManager.ACTIVE.getRegistry(ModuleData.class);
        }
        return MODULE_REGISTRY;
    }

    @Nonnull
    public static IForgeRegistry<RobitSkin> robitSkinRegistry() {
        if (ROBIT_SKIN_REGISTRY == null) {
            ROBIT_SKIN_REGISTRY = RegistryManager.ACTIVE.getRegistry(RobitSkin.class);
        }
        return ROBIT_SKIN_REGISTRY;
    }

    public static IModuleHelper getModuleHelper() {
        if (MODULE_HELPER == null) {
            try {
                Class<?> clazz = Class.forName("mekanism.common.content.gear.ModuleHelper");
                MODULE_HELPER = (IModuleHelper)clazz.getField("INSTANCE").get(null);
            }
            catch (ReflectiveOperationException ex) {
                logger.fatal("Error retrieving RadiationManager, Mekanism may be absent, damaged, or outdated.");
            }
        }
        return MODULE_HELPER;
    }

    public static IRadiationManager getRadiationManager() {
        if (RADIATION_MANAGER == null) {
            try {
                Class<?> clazz = Class.forName("mekanism.common.lib.radiation.RadiationManager");
                RADIATION_MANAGER = (IRadiationManager)clazz.getField("INSTANCE").get(null);
            }
            catch (ReflectiveOperationException ex) {
                logger.fatal("Error retrieving RadiationManager, Mekanism may be absent, damaged, or outdated.");
            }
        }
        return RADIATION_MANAGER;
    }

    public static ITooltipHelper getTooltipHelper() {
        if (TOOLTIP_HELPER == null) {
            try {
                Class<?> clazz = Class.forName("mekanism.common.util.text.TooltipHelper");
                TOOLTIP_HELPER = (ITooltipHelper)clazz.getField("INSTANCE").get(null);
            }
            catch (ReflectiveOperationException ex) {
                logger.fatal("Error retrieving TooltipHelper, Mekanism may be absent, damaged, or outdated.");
            }
        }
        return TOOLTIP_HELPER;
    }

    static {
        EMPTY_GAS = new EmptyGas();
        EMPTY_INFUSE_TYPE = new EmptyInfuseType();
        EMPTY_PIGMENT = new EmptyPigment();
        EMPTY_SLURRY = new EmptySlurry();
    }
}

