/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.ItemInit;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class RainGutter
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    private static final BooleanProperty WATER = BooleanProperty.func_177716_a((String)"water");
    protected static final VoxelShape AABB_SLAB_TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape NWD_CORNER = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.func_208617_a((double)0.0, (double)10.0, (double)8.0, (double)8.0, (double)15.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.func_208617_a((double)8.0, (double)10.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.func_208617_a((double)8.0, (double)10.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = RainGutter.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = RainGutter.makeShapes(AABB_SLAB_BOTTOM, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    private static final int[] PALETTE_SHAPE_MAP = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(bits -> RainGutter.combineShapes(bits, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public RainGutter(BlockState state, AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a(SHAPE, (Comparable)RainGutter.getShapeProperty(stateIn, (IBlockReader)worldIn, currentPos)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected boolean isRainingday(World world, BlockPos pos) {
        return world.func_175727_C(pos);
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        if (((Boolean)p_149653_1_.func_177229_b((Property)WATER)).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (world.func_175727_C(blockpos) && !((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(true)));
        }
        if (!world.func_175727_C(blockpos) && ((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b(SHAPE) != null ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[PALETTE_SHAPE_MAP[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState p_196511_1_) {
        return ((StairsShape)p_196511_1_.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)p_196511_1_.func_177229_b((Property)FACING)).func_176736_b();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        Boolean i = (Boolean)state.func_177229_b((Property)WATER);
        if (item == Items.field_151131_as && !i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        if (item == Items.field_151133_ar && i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            itemstack.func_190918_g(1);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
        }
        if (item == ItemInit.roofing_hammer) {
            state = (BlockState)state.func_235896_a_(SHAPE);
            world.func_180501_a(pos, state, 2);
        }
        if (item == Items.field_151069_bo && i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            player.func_184611_a(hand, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b));
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
        return (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)RainGutter.getShapeProperty(blockstate, (IBlockReader)context.func_195991_k(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (RainGutter.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && RainGutter.isDifferentStairs(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (RainGutter.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && RainGutter.isDifferentStairs(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !RainGutter.isBlockStairs(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof RainGutter;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATER, FACING, SHAPE});
    }
}

