/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.preferences;

import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.gui.BuffStyle;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.PacketSendPreferencesToClient;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.network.NetworkDirection;

public class PreferencesProperties {
    private static final int DEFAULT_BUFFX = -20;
    private static final int DEFAULT_BUFFY = -20;
    private static final GuiStyle DEFAULT_STYLE = GuiStyle.STYLE_FLAT_GRADIENT;
    private int buffX = -20;
    private int buffY = -20;
    private BuffStyle buffStyle = BuffStyle.BOTRIGHT;
    private GuiStyle style = DEFAULT_STYLE;
    private boolean dirty = true;

    public void tick(ServerPlayerEntity player) {
        if (this.dirty) {
            this.syncToClient(player);
        }
    }

    private void syncToClient(ServerPlayerEntity player) {
        McJtyLib.networkHandler.sendTo((Object)new PacketSendPreferencesToClient(this.buffStyle, this.buffX, this.buffY, this.style), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        this.dirty = false;
    }

    public void saveNBTData(CompoundNBT compound) {
        compound.func_74778_a("buffStyle", this.buffStyle.getName());
        compound.func_74768_a("buffX", this.buffX);
        compound.func_74768_a("buffY", this.buffY);
        compound.func_74778_a("style", this.style.getStyle());
    }

    public void loadNBTData(CompoundNBT compound) {
        this.buffStyle = BuffStyle.getStyle(compound.func_74779_i("buffStyle"));
        if (this.buffStyle == null) {
            this.buffStyle = BuffStyle.BOTRIGHT;
            this.buffX = -20;
            this.buffY = -20;
        } else {
            this.buffX = compound.func_74762_e("buffX");
            this.buffY = compound.func_74762_e("buffY");
        }
        String s = compound.func_74779_i("style");
        this.style = GuiStyle.getStyle(s);
        if (this.style == null) {
            this.style = DEFAULT_STYLE;
        }
        this.dirty = true;
    }

    public void reset() {
        this.buffStyle = BuffStyle.TOPLEFT;
        this.buffX = -20;
        this.buffY = -20;
        this.style = DEFAULT_STYLE;
        this.dirty = true;
    }

    public boolean setStyle(String s) {
        GuiStyle st = GuiStyle.getStyle(s);
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    public boolean setStyle(GuiStyle st) {
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    @Nonnull
    public GuiStyle getStyle() {
        return this.style;
    }

    public void setBuffXY(BuffStyle buffStyle, int x, int y) {
        this.buffStyle = buffStyle;
        this.buffX = x;
        this.buffY = y;
        this.dirty = true;
    }

    public BuffStyle getBuffStyle() {
        return this.buffStyle;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PreferencesProperties.class, (Capability.IStorage)new Capability.IStorage<PreferencesProperties>(){

            public INBT writeNBT(Capability<PreferencesProperties> capability, PreferencesProperties instance, Direction side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<PreferencesProperties> capability, PreferencesProperties instance, Direction side, INBT nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }
}

