/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import com.google.common.collect.Range;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.CraftingSlot;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import mcjty.lib.network.PacketContainerDataToClient;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GenericContainer
extends Container
implements IGenericContainer {
    protected final Map<String, IItemHandler> inventories = new HashMap<String, IItemHandler>();
    private final Map<ResourceLocation, IContainerDataListener> containerData = new HashMap<ResourceLocation, IContainerDataListener>();
    private final ContainerFactory factory;
    protected final BlockPos pos;
    protected final GenericTileEntity te;
    private final List<IntReferenceHolder> intReferenceHolders = new ArrayList<IntReferenceHolder>();
    private boolean doForce = true;
    private final PlayerEntity player;

    public GenericContainer(@Nullable ContainerType<?> type, int id, ContainerFactory factory, BlockPos pos, @Nullable GenericTileEntity te, @Nonnull PlayerEntity player) {
        super(type, id);
        this.factory = factory;
        this.pos = pos;
        this.te = te;
        this.player = player;
    }

    public GenericContainer(@Nonnull Supplier<ContainerType<GenericContainer>> type, int id, @Nonnull Supplier<ContainerFactory> factory, @Nullable GenericTileEntity te, @Nonnull PlayerEntity player) {
        super(type.get(), id);
        this.factory = factory.get();
        this.pos = te.func_174877_v();
        this.te = te;
        this.player = player;
    }

    @Override
    public Container getAsContainer() {
        return this;
    }

    public GenericTileEntity getTe() {
        return this.te;
    }

    @Nonnull
    protected IntReferenceHolder func_216958_a(@Nonnull IntReferenceHolder holder) {
        this.intReferenceHolders.add(holder);
        return super.func_216958_a(holder);
    }

    @Override
    public void addShortListener(IntReferenceHolder holder) {
        this.func_216958_a(holder);
    }

    @Override
    public void addIntegerListener(final IntReferenceHolder holder) {
        this.func_216958_a(new IntReferenceHolder(){
            private int lastKnown;

            public int func_221495_b() {
                return holder.func_221495_b() & 0xFFFF;
            }

            public void func_221494_a(int val) {
                int full = holder.func_221495_b();
                holder.func_221494_a(full & 0xFFFF0000 | val & 0xFFFF);
            }

            public boolean func_221496_c() {
                int i = this.func_221495_b();
                boolean flag = i != this.lastKnown;
                this.lastKnown = i;
                return flag;
            }
        });
        this.func_216958_a(new IntReferenceHolder(){
            private int lastKnown;

            public int func_221495_b() {
                return holder.func_221495_b() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int val) {
                int full = holder.func_221495_b();
                holder.func_221494_a(full & 0xFFFF | (val & 0xFFFF) << 16);
            }

            public boolean func_221496_c() {
                int i = this.func_221495_b();
                boolean flag = i != this.lastKnown;
                this.lastKnown = i;
                return flag;
            }
        });
    }

    @Override
    public void addContainerDataListener(IContainerDataListener data) {
        this.containerData.put(data.getId(), data);
    }

    public void addInventory(String name, @Nullable IItemHandler inventory) {
        if (inventory != null) {
            this.inventories.put(name, inventory);
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IItemHandler getInventory(String name) {
        return this.inventories.get(name);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.te == null || this.te.canPlayerAccess(player);
    }

    public SlotType getSlotType(int index) {
        return this.factory.getSlotType(index);
    }

    @Nullable
    public Slot getSlotByInventoryAndIndex(String name, int index) {
        IItemHandler inv = this.inventories.get(name);
        if (inv == null) {
            return null;
        }
        for (Slot slot : this.field_75151_b) {
            IItemHandler itemHandler;
            if (!(slot instanceof SlotItemHandler) || (itemHandler = ((SlotItemHandler)slot).getItemHandler()) != inv || slot.getSlotIndex() != index) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void setupInventories(IItemHandler itemHandler, PlayerInventory inventory) {
        this.addInventory("container", itemHandler);
        this.addInventory("player", (IItemHandler)new InvWrapper((IInventory)inventory));
        this.generateSlots(inventory.field_70458_d);
    }

    public void generateSlots(PlayerEntity player) {
        for (SlotFactory slotFactory : this.factory.getSlots()) {
            IItemHandler inventory = this.inventories.get(slotFactory.getInventoryName());
            int index = slotFactory.getIndex();
            int x = slotFactory.getX();
            int y = slotFactory.getY();
            SlotType slotType = slotFactory.getSlotType();
            Slot slot = this.createSlot(slotFactory, player, inventory, index, x, y, slotType);
            this.func_75146_a(slot);
        }
    }

    protected Slot createSlot(SlotFactory slotFactory, PlayerEntity playerEntity, IItemHandler inventory, int index, int x, int y, SlotType slotType) {
        SlotItemHandler slot;
        if (slotType == SlotType.SLOT_GHOST) {
            slot = new GhostSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_GHOSTOUT) {
            slot = new GhostOutputSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_SPECIFICITEM) {
            final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
            slot = new SlotItemHandler(inventory, index, x, y){

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return slotDefinition.itemStackMatches(stack);
                }
            };
        } else {
            slot = slotType == SlotType.SLOT_CRAFTRESULT ? new CraftingSlot(playerEntity, inventory, this.te, index, x, y).onCraft(slotFactory.getSlotDefinition().getOnCraft()) : new BaseSlot(inventory, this.te, index, x, y);
        }
        return slot;
    }

    private boolean mergeItemStacks(ItemStack itemStack, SlotType slotType, boolean reverse) {
        if (slotType == SlotType.SLOT_SPECIFICITEM) {
            return this.mergeItemStacks(itemStack, (SlotDefinition definition) -> definition.isSpecific() && definition.itemStackMatches(itemStack), reverse);
        }
        return this.mergeItemStacks(itemStack, (SlotDefinition definition) -> definition.getType() == slotType, reverse);
    }

    private boolean mergeItemStacks(ItemStack itemStack, Predicate<SlotDefinition> slotType, boolean reverse) {
        SlotRanges ranges = this.factory.getRanges(slotType);
        Set<Range<Integer>> set = ranges.asRanges();
        if (set.isEmpty()) {
            return false;
        }
        for (Range<Integer> r : ranges.asRanges()) {
            Integer start = (Integer)r.lowerEndpoint();
            int end = (Integer)r.upperEndpoint();
            if (!this.func_75135_a(itemStack, start, end, reverse)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            itemstack = origStack.func_77946_l();
            if (this.factory.isSpecificItemSlot(index)) {
                if (!this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, true) && !this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(origStack, itemstack);
            } else if (this.factory.isOutputSlot(index) || this.factory.isInputSlot(index) || this.factory.isGenericSlot(index)) {
                if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, true) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false))) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(origStack, itemstack);
            } else {
                if (this.factory.isGhostSlot(index) || this.factory.isGhostOutputSlot(index)) {
                    return ItemStack.field_190927_a;
                }
                if (this.factory.isPlayerInventorySlot(index)) {
                    if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotDefinition::isInput, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false))) {
                        return ItemStack.field_190927_a;
                    }
                } else if (this.factory.isPlayerHotbarSlot(index)) {
                    if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotDefinition::isInput, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, false))) {
                        return ItemStack.field_190927_a;
                    }
                } else {
                    Logging.log("Weird slot at index: " + index);
                }
            }
            if (origStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (origStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, origStack);
        }
        return itemstack;
    }

    protected boolean func_75135_a(@Nonnull ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reverseOrder) {
        int amount;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reverseOrder) {
            checkIndex = toIndex - 1;
        }
        ItemStack itemstack1 = ItemStack.field_190927_a;
        if (par1ItemStack.func_77985_e()) {
            while (!par1ItemStack.func_190926_b() && (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && par1ItemStack.func_77952_i() == itemstack1.func_77952_i() && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack)) {
                    int maxStackSize;
                    int mergedSize = itemstack1.func_190916_E() + par1ItemStack.func_190916_E();
                    if (mergedSize <= (maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a()))) {
                        par1ItemStack.func_190920_e(0);
                        if (mergedSize <= 0) {
                            itemstack1.func_190920_e(0);
                        } else {
                            itemstack1.func_190920_e(mergedSize);
                        }
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.func_190916_E() < maxStackSize) {
                        amount = -(maxStackSize - itemstack1.func_190916_E());
                        par1ItemStack.func_190917_f(amount);
                        if (maxStackSize <= 0) {
                            itemstack1.func_190920_e(0);
                        } else {
                            itemstack1.func_190920_e(maxStackSize);
                        }
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (!par1ItemStack.func_190926_b()) {
            checkIndex = reverseOrder ? toIndex - 1 : fromIndex;
            while (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1.func_190926_b() && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    int amount1 = Math.min(in.func_190916_E(), slot.func_75219_a());
                    if (amount1 <= 0) {
                        in.func_190920_e(0);
                    } else {
                        in.func_190920_e(amount1);
                    }
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    if (in.func_190916_E() >= par1ItemStack.func_190916_E()) {
                        par1ItemStack.func_190920_e(0);
                    } else {
                        amount = -in.func_190916_E();
                        par1ItemStack.func_190917_f(amount);
                    }
                    result = true;
                    break;
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    @Nonnull
    public ItemStack func_184996_a(int index, int button, @Nonnull ClickType mode, @Nonnull PlayerEntity player) {
        if (this.factory.isGhostSlot(index)) {
            ItemStack clickedWith;
            Slot slot = this.func_75139_a(index);
            if (slot.func_75216_d()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            if (!(clickedWith = player.field_71071_by.func_70445_o()).func_190926_b()) {
                ItemStack copy = clickedWith.func_77946_l();
                copy.func_190920_e(1);
                slot.func_75215_d(copy);
            }
            this.func_75142_b();
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(index, button, mode, player);
    }

    public IContainerDataListener getListener(ResourceLocation id) {
        return this.containerData.get(id);
    }

    private void broadcast() {
        for (int i = 0; i < this.intReferenceHolders.size(); ++i) {
            IntReferenceHolder holder = this.intReferenceHolders.get(i);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, i, holder.func_221495_b());
            }
        }
        if (this.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            for (IContainerDataListener data : this.containerData.values()) {
                ByteBuf newbuf = Unpooled.buffer();
                PacketBuffer buffer = new PacketBuffer(newbuf);
                data.toBytes(buffer);
                PacketContainerDataToClient packet = new PacketContainerDataToClient(data.getId(), buffer);
                McJtyLib.networkHandler.sendTo((Object)packet, serverPlayer.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void forceBroadcast() {
        this.doForce = true;
    }

    public void func_75142_b() {
        if (this.doForce) {
            this.broadcast();
            this.doForce = false;
        }
        super.func_75142_b();
        if (this.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            for (IContainerDataListener data : this.containerData.values()) {
                if (!data.isDirtyAndClear()) continue;
                ByteBuf newbuf = Unpooled.buffer();
                PacketBuffer buffer = new PacketBuffer(newbuf);
                data.toBytes(buffer);
                PacketContainerDataToClient packet = new PacketContainerDataToClient(data.getId(), buffer);
                McJtyLib.networkHandler.sendTo((Object)packet, serverPlayer.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public static ContainerType<Container> createContainerType(String registryName) {
        ContainerType containerType = IForgeContainerType.create((windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity te = inv.field_70458_d.func_130014_f_().func_175625_s(pos);
            if (te == null) {
                throw new IllegalStateException("Something went wrong getting the GUI");
            }
            return (Container)te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> Objects.requireNonNull(h.createMenu(windowId, inv, inv.field_70458_d))).orElseThrow(RuntimeException::new);
        });
        containerType.setRegistryName(registryName);
        return containerType;
    }

    public static <T extends Container> ContainerType<T> createContainerType() {
        ContainerType containerType = IForgeContainerType.create((windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity te = inv.field_70458_d.func_130014_f_().func_175625_s(pos);
            if (te == null) {
                throw new IllegalStateException("Something went wrong getting the GUI");
            }
            return (Container)te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> Objects.requireNonNull(h.createMenu(windowId, inv, inv.field_70458_d))).orElseThrow(RuntimeException::new);
        });
        return containerType;
    }

    public static <T extends GenericContainer, E extends GenericTileEntity> ContainerType<T> createRemoteContainerType(Function<RegistryKey<World>, E> dummyTEFactory, ContainerSupplier<T, E> containerFactory, int slots) {
        return IForgeContainerType.create((windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            GenericTileEntity te = (GenericTileEntity)((Object)((Object)dummyTEFactory.apply(LevelTools.getId(data.func_192575_l()))));
            te.func_226984_a_(inv.field_70458_d.func_130014_f_(), pos);
            CompoundNBT compound = data.func_150793_b();
            te.load(compound);
            Object container = containerFactory.create(windowId, pos, te, inv.field_70458_d);
            ((GenericContainer)container).setupInventories((IItemHandler)new ItemStackHandler(slots), inv);
            return container;
        });
    }

    public static interface ContainerSupplier<T extends GenericContainer, E extends GenericTileEntity> {
        public T create(int var1, BlockPos var2, E var3, PlayerEntity var4);
    }
}

