/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.CofhApiItemCompatibility;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.multipart.IPartBlock;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.WrenchChecker;
import mcjty.lib.varia.WrenchUsage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class BaseBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider,
IPartBlock,
ITooltipSettings {
    private final boolean infusable;
    private final Supplier<TileEntity> tileEntitySupplier;
    private final TooltipBuilder tooltipBuilder;
    private final ToolType toolType;
    private final int harvestLevel;
    private final TOPDriver topDriver;
    private final ManualEntry manualEntry;
    public static final Property<?>[] HORIZ_PROPERTIES = new Property[]{BlockStateProperties.field_208157_J};
    public static final Property<?>[] ROTATING_PROPERTIES = new Property[]{BlockStateProperties.field_208155_H};
    public static final Property<?>[] NONE_PROPERTIES = new Property[0];

    public BaseBlock(BlockBuilder builder) {
        super(builder.getProperties());
        this.infusable = builder.isInfusable();
        this.tileEntitySupplier = builder.getTileEntitySupplier();
        this.tooltipBuilder = builder.getTooltipBuilder();
        this.toolType = builder.getToolType();
        this.harvestLevel = builder.getHarvestLevel();
        this.topDriver = builder.getTopDriver();
        this.manualEntry = builder.getManualEntry();
    }

    @Override
    public ManualEntry getManualEntry() {
        return this.manualEntry;
    }

    public static void setInfused(ItemStack stack, int infused) {
        NBTTools.setInfoNBT(stack, CompoundNBT::func_74768_a, "infused", infused);
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag advanced) {
        this.intAddInformation(stack, tooltip);
        if (this.tooltipBuilder.isActive()) {
            this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, tooltip, advanced);
        }
    }

    private void intAddInformation(ItemStack itemStack, List<ITextComponent> list) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("Energy")) {
                long energy = tagCompound.func_74763_f("Energy");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Energy: " + energy + " rf"));
            }
            if (this.isInfusable()) {
                int infused = BaseBlock.getInfused(itemStack);
                int pct = infused * 100 / (Integer)GeneralConfig.maxInfuse.get();
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Infused: " + pct + "%"));
            }
            if (((Boolean)GeneralConfig.manageOwnership.get()).booleanValue() && tagCompound.func_74764_b("owner")) {
                String owner = tagCompound.func_74779_i("owner");
                int securityChannel = -1;
                if (tagCompound.func_74764_b("secChannel")) {
                    securityChannel = tagCompound.func_74762_e("secChannel");
                }
                if (securityChannel == -1) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Owned by: " + owner));
                } else {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Owned by: " + owner + " (channel " + securityChannel + ")"));
                }
                if (!tagCompound.func_74764_b("idM")) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!"));
                }
            }
        }
    }

    public static int getInfused(ItemStack itemStack) {
        return NBTTools.getInfoNBT(itemStack, CompoundNBT::func_74762_e, "infused", 0);
    }

    private WrenchUsage testWrenchUsage(BlockPos pos, PlayerEntity player) {
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        WrenchUsage wrenchUsed = WrenchUsage.NOT;
        if (!itemStack.func_190926_b()) {
            Item item = itemStack.func_77973_b();
            wrenchUsed = this.getWrenchUsage(pos, player, itemStack, wrenchUsed, item);
        }
        if (wrenchUsed == WrenchUsage.NORMAL && player.func_225608_bj_()) {
            wrenchUsed = WrenchUsage.SNEAKING;
        }
        return wrenchUsed;
    }

    protected WrenchUsage getWrenchUsage(BlockPos pos, PlayerEntity player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        if (item instanceof SmartWrench) {
            switch (((SmartWrench)item).getMode(itemStack)) {
                case MODE_WRENCH: {
                    return WrenchUsage.NORMAL;
                }
                case MODE_SELECT: {
                    return player.func_225608_bj_() ? WrenchUsage.SNEAK_SELECT : WrenchUsage.SELECT;
                }
            }
            throw new RuntimeException("SmartWrench in unknown mode!");
        }
        if (McJtyLib.cofhapiitem && CofhApiItemCompatibility.isToolHammer(item)) {
            return CofhApiItemCompatibility.getWrenchUsage(item, itemStack, player, pos);
        }
        if (WrenchChecker.isAWrench(item)) {
            return WrenchUsage.NORMAL;
        }
        return wrenchUsed;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult result) {
        ActionResultType resultType;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && (resultType = ((GenericTileEntity)te).onBlockActivated(state, player, hand, result)) != ActionResultType.PASS) {
            return resultType;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.handleModule(world, pos, state, player, hand, heldItem, result)) {
            return ActionResultType.SUCCESS;
        }
        WrenchUsage wrenchUsed = this.testWrenchUsage(pos, player);
        switch (wrenchUsed) {
            case NOT: {
                return this.openGui(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            case NORMAL: {
                return this.wrenchUse(world, pos, result.func_216354_b(), player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            case SNEAKING: {
                return this.wrenchSneak(world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            case DISABLED: {
                return this.wrenchDisabled(world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            case SELECT: {
                return this.wrenchSelect(world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            case SNEAK_SELECT: {
                return this.wrenchSneakSelect(world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean handleModule(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, ItemStack heldItem, BlockRayTraceResult result) {
        TileEntity te;
        if (!heldItem.func_190926_b() && (te = world.func_175625_s(pos)) != null) {
            return te.getCapability(CapabilityModuleSupport.MODULE_CAPABILITY).map(h -> {
                if (h.isModule(heldItem) && ModuleTools.installModule(player, heldItem, hand, pos, h.getFirstSlot(), h.getLastSlot())) {
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            if (!((GenericTileEntity)tileEntity).wrenchUse(world, pos, side, player)) {
                this.rotate(world.func_180495_p(pos), (IWorld)world, pos, Rotation.CLOCKWISE_90);
            }
        } else {
            this.rotate(world.func_180495_p(pos), (IWorld)world, pos, Rotation.CLOCKWISE_90);
        }
        return true;
    }

    protected boolean wrenchSneak(World world, BlockPos pos, PlayerEntity player) {
        this.breakAndRemember(world, player, pos);
        return true;
    }

    protected void breakAndRemember(World world, PlayerEntity player, BlockPos pos) {
        if (!world.field_72995_K) {
            this.func_180657_a(world, player, pos, world.func_180495_p(pos), world.func_175625_s(pos), ItemStack.field_190927_a);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    protected boolean wrenchDisabled(World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    protected boolean wrenchSelect(World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    protected boolean openGui(World world, int x, int y, int z, PlayerEntity player) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te == null) {
            return false;
        }
        return te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> {
            if (world.field_72995_K) {
                return true;
            }
            if (this.checkAccess(world, player, te)) {
                return true;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)h, (BlockPos)te.func_174877_v());
            return true;
        }).orElse(false);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && ((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            this.setOwner(world, pos, placer);
        }
        if ((te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockPlacedBy(world, pos, state, placer, stack);
        }
        this.checkRedstone(world, pos);
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        this.checkRedstone(world, pos);
    }

    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).checkRedstone(world, pos);
        }
    }

    protected void setOwner(World world, BlockPos pos, LivingEntity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && entity instanceof PlayerEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            PlayerEntity player = (PlayerEntity)entity;
            genericTileEntity.setOwner(player);
        }
    }

    public boolean func_189539_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, int id, int param) {
        if (this.hasTileEntity(state)) {
            super.func_189539_a(state, worldIn, pos, id, param);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(id, param);
        }
        return super.func_189539_a(state, worldIn, pos, id, param);
    }

    protected boolean checkAccess(World world, PlayerEntity player, TileEntity te) {
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).checkAccess(player);
        }
        return false;
    }

    @Nullable
    public ToolType getHarvestTool(@Nonnull BlockState state) {
        return this.toolType;
    }

    public int getHarvestLevel(@Nonnull BlockState state) {
        return this.harvestLevel;
    }

    public boolean hasTileEntity(BlockState state) {
        return this.tileEntitySupplier != null;
    }

    public RotationType getRotationType() {
        return RotationType.ROTATION;
    }

    public boolean isInfusable() {
        return this.infusable;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this.tileEntitySupplier == null) {
            return null;
        }
        return this.tileEntitySupplier.get();
    }

    @Override
    @Nonnull
    public PartSlot getSlotFromState(World world, BlockPos pos, BlockState newState) {
        return PartSlot.NONE;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onReplaced(world, pos, state, newstate);
        }
        super.func_196243_a(state, world, pos, newstate, isMoving);
    }

    protected Property<?>[] getProperties() {
        return BaseBlock.getProperties(this.getRotationType());
    }

    public static Property<?>[] getProperties(RotationType rotationType) {
        switch (rotationType) {
            case HORIZROTATION: {
                return HORIZ_PROPERTIES;
            }
            case ROTATION: {
                return ROTATING_PROPERTIES;
            }
        }
        return NONE_PROPERTIES;
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        for (Property<?> property : this.getProperties()) {
            builder.func_206894_a(new Property[]{property});
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        PlayerEntity placer = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        BlockState state = super.func_196258_a(context);
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)placer.func_174811_aO().func_176734_d());
            }
            case ROTATION: {
                return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)OrientationTools.getFacingFromEntity(pos, (Entity)placer));
            }
        }
        return state;
    }

    protected Direction getOrientation(BlockPos pos, LivingEntity entity) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.determineOrientationHoriz(entity);
            }
            case ROTATION: {
                return OrientationTools.determineOrientation(pos, entity);
            }
        }
        return null;
    }

    public Direction getFrontDirection(BlockState state) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            }
            case ROTATION: {
                return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            }
        }
        return Direction.NORTH;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
                break;
            }
            case ROTATION: {
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)));
                break;
            }
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            ((GenericTileEntity)tileEntity).rotateBlock(rot);
        }
        return state;
    }

    public Direction getRightDirection(BlockState state) {
        return this.getFrontDirection(state).func_176735_f();
    }

    public Direction getLeftDirection(BlockState state) {
        return this.getFrontDirection(state).func_176746_e();
    }

    public static Direction getFrontDirection(RotationType rotationType, BlockState state) {
        switch (rotationType) {
            case HORIZROTATION: {
                return OrientationTools.getOrientationHoriz(state);
            }
            case ROTATION: {
                return OrientationTools.getOrientation(state);
            }
        }
        return Direction.SOUTH;
    }

    @Override
    public TOPDriver getProbeDriver() {
        return this.topDriver;
    }
}

