/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.util.JsonHelper;

public class FluidContainerIngredient
extends Ingredient {
    public static final ResourceLocation ID = Mantle.getResource("fluid_container");
    public static final Serializer SERIALIZER = new Serializer();
    private final FluidIngredient fluidIngredient;
    @Nullable
    private final Ingredient display;
    private ItemStack[] displayStacks;

    protected FluidContainerIngredient(FluidIngredient fluidIngredient, @Nullable Ingredient display) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.fluidIngredient = fluidIngredient;
        this.display = display;
    }

    public static FluidContainerIngredient fromIngredient(FluidIngredient ingredient, Ingredient display) {
        return new FluidContainerIngredient(ingredient, display);
    }

    public static FluidContainerIngredient fromIngredient(FluidIngredient ingredient) {
        return new FluidContainerIngredient(ingredient, null);
    }

    public static FluidContainerIngredient fromFluid(FluidObject<?> fluid, boolean forgeTag) {
        return FluidContainerIngredient.fromIngredient(FluidIngredient.of(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag(), 1000), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{fluid}));
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve().flatMap(cap -> {
            FluidStack contained;
            if (cap.getTanks() == 1 && !(contained = cap.getFluidInTank(0)).isEmpty() && this.fluidIngredient.getAmount(contained.getFluid()) == contained.getAmount() && this.fluidIngredient.test(contained.getFluid())) {
                ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                return copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve();
            }
            return Optional.empty();
        }).filter(cap -> {
            Fluid fluid = cap.getFluidInTank(0).getFluid();
            int amount = this.fluidIngredient.getAmount(fluid);
            FluidStack drained = cap.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            return drained.getFluid() == fluid && drained.getAmount() == amount && ItemStack.func_77989_b((ItemStack)stack.getContainerItem(), (ItemStack)cap.getContainer());
        }).isPresent();
    }

    public ItemStack[] func_193365_a() {
        if (this.displayStacks == null) {
            this.displayStacks = this.display == null ? new ItemStack[0] : this.display.func_193365_a();
        }
        return this.displayStacks;
    }

    public JsonElement func_200304_c() {
        JsonObject json;
        JsonElement element = this.fluidIngredient.serialize();
        if (element.isJsonObject()) {
            json = element.getAsJsonObject();
        } else {
            json = new JsonObject();
            json.add("fluid", element);
        }
        json.addProperty("type", ID.toString());
        if (this.display != null) {
            json.add("display", this.display.func_200304_c());
        }
        return json;
    }

    protected void invalidate() {
        super.invalidate();
        this.displayStacks = null;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<FluidContainerIngredient> {
        private Serializer() {
        }

        public FluidContainerIngredient parse(JsonObject json) {
            FluidIngredient fluidIngredient = json.has("fluid") ? FluidIngredient.deserialize(json, "fluid") : FluidIngredient.deserialize((JsonElement)json, "fluid");
            Ingredient display = null;
            if (json.has("display")) {
                display = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement(json, "display"));
            }
            return new FluidContainerIngredient(fluidIngredient, display);
        }

        public FluidContainerIngredient parse(PacketBuffer buffer) {
            FluidIngredient fluidIngredient = FluidIngredient.read(buffer);
            Ingredient display = null;
            if (buffer.readBoolean()) {
                display = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            return new FluidContainerIngredient(fluidIngredient, display);
        }

        public void write(PacketBuffer buffer, FluidContainerIngredient ingredient) {
            ingredient.fluidIngredient.write(buffer);
            if (ingredient.display != null) {
                buffer.writeBoolean(true);
                ingredient.display.func_199564_a(buffer);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

