/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.TagCollectionArgument;

public class TagsForCommand {
    protected static final Dynamic2CommandExceptionType VALUE_NOT_FOUND = new Dynamic2CommandExceptionType((type, name) -> new TranslationTextComponent("command.mantle.tags_for.not_found", new Object[]{type, name}));
    private static final ITextComponent NO_HELD_BLOCK = new TranslationTextComponent("command.mantle.tags_for.no_held_block");
    private static final ITextComponent NO_HELD_ENTITY = new TranslationTextComponent("command.mantle.tags_for.no_held_entity");
    private static final ITextComponent NO_HELD_POTION = new TranslationTextComponent("command.mantle.tags_for.no_held_potion");
    private static final ITextComponent NO_HELD_FLUID = new TranslationTextComponent("command.mantle.tags_for.no_held_fluid");
    private static final ITextComponent NO_HELD_ENCHANTMENT = new TranslationTextComponent("command.mantle.tags_for.no_held_enchantment");
    private static final ITextComponent NO_TARGETED_ENTITY = new TranslationTextComponent("command.mantle.tags_for.no_targeted_entity");
    private static final ITextComponent NO_TARGETED_TILE_ENTITY = new TranslationTextComponent("command.mantle.tags_for.no_targeted_tile_entity");
    private static final ITextComponent NO_TAGS = new TranslationTextComponent("command.mantle.tags_for.no_tags");

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(Commands.func_197057_a((String)"id").then(Commands.func_197056_a((String)"type", (ArgumentType)TagCollectionArgument.collection()).then(Commands.func_197056_a((String)"name", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(MantleCommand.REGISTRY_VALUES).executes(TagsForCommand::runForId))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"held").then(Commands.func_197057_a((String)"item").executes(TagsForCommand::heldItem))).then(Commands.func_197057_a((String)"block").executes(TagsForCommand::heldBlock))).then(Commands.func_197057_a((String)"enchantment").executes(TagsForCommand::heldEnchantments))).then(Commands.func_197057_a((String)"fluid").executes(TagsForCommand::heldFluid))).then(Commands.func_197057_a((String)"entity").executes(TagsForCommand::heldEntity))).then(Commands.func_197057_a((String)"potion").executes(TagsForCommand::heldPotion)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"targeted").then(Commands.func_197057_a((String)"tile_entity").executes(TagsForCommand::targetedTileEntity))).then(Commands.func_197057_a((String)"entity").executes(TagsForCommand::targetedEntity)));
    }

    private static <T> int printOwningTags(CommandContext<CommandSource> context, ITagCollection<T> collection, ResourceLocation typeName, ResourceLocation name, Object value) {
        TranslationTextComponent output = new TranslationTextComponent("command.mantle.tags_for.success", new Object[]{typeName, name});
        Collection tags = collection.func_199913_a(value);
        if (tags.isEmpty()) {
            output.func_240702_b_("\n* ").func_230529_a_(NO_TAGS);
        } else {
            tags.stream().sorted(ResourceLocation::compareNamespaced).forEach(arg_0 -> TagsForCommand.lambda$printOwningTags$2((IFormattableTextComponent)output, arg_0));
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)output, true);
        return tags.size();
    }

    private static int runForId(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TagCollectionArgument.Result result = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        if (!result.getRegistry().containsKey(name)) {
            throw VALUE_NOT_FOUND.create((Object)result.getName(), (Object)name);
        }
        IForgeRegistryEntry value = result.getRegistry().getValue(name);
        if (value == null) {
            throw VALUE_NOT_FOUND.create((Object)result.getName(), (Object)name);
        }
        return TagsForCommand.printOwningTags(context, result.getCollection(), result.getName(), name, value);
    }

    private static int heldItem(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Item item = ((CommandSource)context.getSource()).func_197035_h().func_184614_ca().func_77973_b();
        return TagsForCommand.printOwningTags(context, TagCollectionManager.func_242178_a().func_241836_b(), Registry.field_239714_o_.func_240901_a_(), Objects.requireNonNull(item.getRegistryName()), item);
    }

    private static int heldBlock(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        Item item = source.func_197035_h().func_184614_ca().func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block != Blocks.field_150350_a) {
            return TagsForCommand.printOwningTags(context, TagCollectionManager.func_242178_a().func_241835_a(), Registry.field_239711_l_.func_240901_a_(), Objects.requireNonNull(block.getRegistryName()), block);
        }
        source.func_197030_a(NO_HELD_BLOCK, true);
        return 0;
    }

    private static int heldFluid(CommandContext<CommandSource> context) throws CommandSyntaxException {
        FluidStack fluidStack;
        IFluidHandler handler;
        CommandSource source = (CommandSource)context.getSource();
        ItemStack stack = source.func_197035_h().func_184614_ca();
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (capability.isPresent() && (handler = (IFluidHandler)capability.map(h -> h).orElse(EmptyFluidHandler.INSTANCE)).getTanks() > 0 && !(fluidStack = handler.getFluidInTank(0)).isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            return TagsForCommand.printOwningTags(context, TagCollectionManager.func_242178_a().func_241837_c(), Registry.field_239709_j_.func_240901_a_(), Objects.requireNonNull(fluid.getRegistryName()), fluid);
        }
        source.func_197030_a(NO_HELD_FLUID, true);
        return 0;
    }

    private static int heldPotion(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        ItemStack stack = source.func_197035_h().func_184614_ca();
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        if (potion != Potions.field_185229_a) {
            ResourceLocation registry = Registry.field_239715_p_.func_240901_a_();
            return TagsForCommand.printOwningTags(context, (ITagCollection)ForgeTagHandler.getCustomTagTypes().get(registry), registry, Objects.requireNonNull(potion.getRegistryName()), potion);
        }
        source.func_197030_a(NO_HELD_POTION, true);
        return 0;
    }

    private static int heldEnchantments(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        ItemStack stack = source.func_197035_h().func_184614_ca();
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchantments.isEmpty()) {
            int totalTags = 0;
            ResourceLocation registry = Registry.field_239712_m_.func_240901_a_();
            ITagCollection enchantmentTags = (ITagCollection)ForgeTagHandler.getCustomTagTypes().get(registry);
            for (Enchantment enchantment : enchantments.keySet()) {
                totalTags += TagsForCommand.printOwningTags(context, enchantmentTags, registry, Objects.requireNonNull(enchantment.getRegistryName()), enchantment);
            }
            return totalTags;
        }
        source.func_197030_a(NO_HELD_ENCHANTMENT, true);
        return 0;
    }

    private static int heldEntity(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        ItemStack stack = source.func_197035_h().func_184614_ca();
        if (stack.func_77973_b() instanceof SpawnEggItem) {
            EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            return TagsForCommand.printOwningTags(context, TagCollectionManager.func_242178_a().func_241838_d(), Registry.field_239713_n_.func_240901_a_(), Objects.requireNonNull(type.getRegistryName()), type);
        }
        source.func_197030_a(NO_HELD_ENTITY, true);
        return 0;
    }

    private static int targetedTileEntity(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TileEntity te;
        CommandSource source = (CommandSource)context.getSource();
        ServerPlayerEntity player = source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        BlockRayTraceResult blockTrace = Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (blockTrace.func_216346_c() == RayTraceResult.Type.BLOCK && (te = world.func_175625_s(blockTrace.func_216350_a())) != null) {
            TileEntityType type = te.func_200662_C();
            ResourceLocation registry = Registry.field_239667_E_.func_240901_a_();
            return TagsForCommand.printOwningTags(context, (ITagCollection)ForgeTagHandler.getCustomTagTypes().get(registry), registry, Objects.requireNonNull(type.getRegistryName()), type);
        }
        source.func_197030_a(NO_TARGETED_TILE_ENTITY, true);
        return 0;
    }

    private static int targetedEntity(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        ServerPlayerEntity player = source.func_197035_h();
        Vector3d start = player.func_174824_e(1.0f);
        Vector3d look = player.func_70040_Z();
        double range = Objects.requireNonNull(player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())).func_111126_e();
        Vector3d direction = start.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        AxisAlignedBB bb = player.func_174813_aQ().func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72321_a(1.0, 1.0, 1.0);
        EntityRayTraceResult entityTrace = ProjectileHelper.func_221269_a((World)source.func_197023_e(), (Entity)player, (Vector3d)start, (Vector3d)direction, (AxisAlignedBB)bb, e -> true);
        if (entityTrace != null) {
            EntityType target = entityTrace.func_216348_a().func_200600_R();
            return TagsForCommand.printOwningTags(context, TagCollectionManager.func_242178_a().func_241838_d(), Registry.field_239713_n_.func_240901_a_(), Objects.requireNonNull(target.getRegistryName()), target);
        }
        source.func_197030_a(NO_TARGETED_ENTITY, true);
        return 0;
    }

    private static /* synthetic */ void lambda$printOwningTags$2(IFormattableTextComponent output, ResourceLocation tag) {
        output.func_240702_b_("\n* " + tag);
    }
}

