/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;

public class MantleItemLayerModel
implements IModelGeometry<MantleItemLayerModel> {
    public static final Loader LOADER = new Loader();
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] VERTICALS = new Direction[]{Direction.WEST, Direction.EAST};
    private final List<LayerData> layers;
    private List<RenderMaterial> textures = Collections.emptyList();

    private LayerData getLayer(int index) {
        if (index < 0 || index >= this.layers.size()) {
            return LayerData.DEFAULT;
        }
        return this.layers.get(index);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (owner.isTexturePresent("layer" + i)) {
            builder.add((Object)owner.resolveTexture("layer" + i));
            ++i;
        }
        this.textures = builder.build();
        return this.textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : this.textures.get(0));
        ReversedListBuilder<BakedQuad> builder = new ReversedListBuilder<BakedQuad>();
        ItemLayerPixels pixels = this.textures.size() == 1 ? null : new ItemLayerPixels();
        TransformationMatrix transform = modelTransform.func_225615_b_();
        for (int i = this.textures.size() - 1; i >= 0; --i) {
            TextureAtlasSprite sprite = spriteGetter.apply(this.textures.get(i));
            LayerData data = this.getLayer(i);
            builder.addAll((Collection<BakedQuad>)MantleItemLayerModel.getQuadsForSprite(data.getColor(), data.isNoTint() ? -1 : i, sprite, transform, data.getLuminosity(), pixels));
        }
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(owner.getCombinedTransform(), modelTransform));
        return new BakedItemModel(builder.build(), particle, Maps.immutableEnumMap((Map)transformMap), overrides, true, owner.isSideLit());
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int color, int tint, TextureAtlasSprite sprite, TransformationMatrix transform, int luminosity) {
        return MantleItemLayerModel.getQuadsForSprite(color, tint, sprite, transform, luminosity, null);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int color, int tint, TextureAtlasSprite sprite, TransformationMatrix transform, int luminosity, @Nullable ItemLayerPixels pixels) {
        int off;
        int off2;
        boolean face;
        boolean canDraw;
        boolean building;
        int u;
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                int ptu = 1;
                for (u = 0; u < uMax; ++u) {
                    int t;
                    int alpha = sprite.getPixelRGBA(f, u, vMax - v - 1) >> 24 & 0xFF;
                    int n = t = (float)alpha / 255.0f <= 0.1f ? 1 : 0;
                    if (t == 0 && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu != 0 && t == 0) {
                        faceData.set(Direction.WEST, u, v);
                    }
                    if (ptu == 0 && t != 0) {
                        faceData.set(Direction.EAST, u - 1, v);
                    }
                    if (ptv[u] && t == 0) {
                        faceData.set(Direction.UP, u, v);
                    }
                    if (!ptv[u] && t != 0) {
                        faceData.set(Direction.DOWN, u, v - 1);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu != 0) continue;
                faceData.set(Direction.EAST, uMax - 1, v);
            }
            for (int u2 = 0; u2 < uMax; ++u2) {
                if (ptv[u2]) continue;
                faceData.set(Direction.DOWN, u2, vMax - 1);
            }
        }
        for (Direction facing : HORIZONTALS) {
            for (int v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    canDraw = pixels == null || !pixels.get(u3, v, uMax, vMax);
                    boolean bl = face = canDraw && faceData.get(facing, u3, v);
                    if (face) {
                        uEnd = u3 + 1;
                        if (building) continue;
                        building = true;
                        uStart = u3;
                        continue;
                    }
                    if (!building || canDraw && !translucent) continue;
                    off2 = facing == Direction.DOWN ? 1 : 0;
                    builder.add((Object)MantleItemLayerModel.buildSideQuad(transform, facing, color, tint, sprite, uStart, v + off2, uEnd - uStart, luminosity));
                    building = false;
                }
                if (!building) continue;
                off = facing == Direction.DOWN ? 1 : 0;
                builder.add((Object)MantleItemLayerModel.buildSideQuad(transform, facing, color, tint, sprite, uStart, v + off, uEnd - uStart, luminosity));
            }
        }
        for (Direction facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v = 0; v < vMax; ++v) {
                    canDraw = pixels == null || !pixels.get(u, v, uMax, vMax);
                    boolean bl = face = canDraw && faceData.get(facing, u, v);
                    if (face) {
                        vEnd = v + 1;
                        if (building) continue;
                        building = true;
                        vStart = v;
                        continue;
                    }
                    if (!building || canDraw && !translucent) continue;
                    off2 = facing == Direction.EAST ? 1 : 0;
                    builder.add((Object)MantleItemLayerModel.buildSideQuad(transform, facing, color, tint, sprite, u + off2, vStart, vEnd - vStart, luminosity));
                    building = false;
                }
                if (!building) continue;
                off = facing == Direction.EAST ? 1 : 0;
                builder.add((Object)MantleItemLayerModel.buildSideQuad(transform, facing, color, tint, sprite, u + off, vStart, vEnd - vStart, luminosity));
            }
        }
        builder.add((Object)MantleItemLayerModel.buildQuad(transform, Direction.NORTH, sprite, color, tint, luminosity, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
        builder.add((Object)MantleItemLayerModel.buildQuad(transform, Direction.SOUTH, sprite, color, tint, luminosity, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
        if (pixels != null && sprite.func_110970_k() > 0) {
            for (int v = 0; v < vMax; ++v) {
                for (int u4 = 0; u4 < uMax; ++u4) {
                    int alpha = sprite.getPixelRGBA(0, u4, vMax - v - 1) >> 24 & 0xFF;
                    if (!((float)alpha / 255.0f > 0.1f)) continue;
                    pixels.set(u4, v, uMax, vMax);
                }
            }
        }
        return builder.build();
    }

    private static BakedQuad buildSideQuad(TransformationMatrix transform, Direction side, int color, int tint, TextureAtlasSprite sprite, int u, int v, int size, int luminosity) {
        float eps = 0.01f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.01f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return MantleItemLayerModel.buildQuad(transform, side.func_176740_k() == Direction.Axis.Y ? side.func_176734_d() : side, sprite, color, tint, luminosity, x0, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    protected static BakedQuad buildQuad(TransformationMatrix transform, Direction side, TextureAtlasSprite sprite, int color, int tint, int luminosity, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setApplyDiffuseLighting(false);
        boolean hasTransform = !transform.isIdentity();
        BakedQuadBuilder consumer = hasTransform ? new TRSRTransformer((IVertexConsumer)builder, transform) : builder;
        MantleItemLayerModel.putVertex((IVertexConsumer)consumer, side, x0, y0, z0, u0, v0, color, luminosity);
        MantleItemLayerModel.putVertex((IVertexConsumer)consumer, side, x1, y1, z1, u1, v1, color, luminosity);
        MantleItemLayerModel.putVertex((IVertexConsumer)consumer, side, x2, y2, z2, u2, v2, color, luminosity);
        MantleItemLayerModel.putVertex((IVertexConsumer)consumer, side, x3, y3, z3, u3, v3, color, luminosity);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, Direction side, float x, float y, float z, float u, float v, int color, int luminosity) {
        VertexFormat format = consumer.getVertexFormat();
        ImmutableList elements = format.func_227894_c_();
        int size = elements.size();
        block10: for (int e = 0; e < size; ++e) {
            VertexFormatElement element = (VertexFormatElement)elements.get(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    consumer.put(e, new float[]{x, y, z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    consumer.put(e, new float[]{r, g, b, a});
                    continue block10;
                }
                case NORMAL: {
                    float offX = side.func_82601_c();
                    float offY = side.func_96559_d();
                    float offZ = side.func_82599_e();
                    consumer.put(e, new float[]{offX, offY, offZ, 0.0f});
                    continue block10;
                }
                case UV: {
                    switch (element.func_177369_e()) {
                        case 0: {
                            consumer.put(e, new float[]{u, v, 0.0f, 1.0f});
                            continue block10;
                        }
                        case 2: {
                            float light = (float)(luminosity << 4) / 32768.0f;
                            consumer.put(e, new float[]{light, light, 0.0f, 1.0f});
                            continue block10;
                        }
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }

    public MantleItemLayerModel(List<LayerData> layers) {
        this.layers = layers;
    }

    private static class Loader
    implements IModelLoader<MantleItemLayerModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public MantleItemLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            List<LayerData> layers = JsonHelper.parseList(modelContents, "layers", LayerData::fromJson);
            return new MantleItemLayerModel(layers);
        }
    }

    private static class LayerData {
        private static final LayerData DEFAULT = new LayerData(-1, 0, false);
        private final int color;
        private final int luminosity;
        private final boolean noTint;

        public static LayerData fromJson(JsonObject json) {
            int color = JsonHelper.parseColor(JSONUtils.func_151219_a((JsonObject)json, (String)"color", (String)""));
            int luminosity = JSONUtils.func_151203_m((JsonObject)json, (String)"luminosity");
            boolean noTint = JSONUtils.func_151209_a((JsonObject)json, (String)"no_tint", (boolean)false);
            return new LayerData(color, luminosity, noTint);
        }

        public LayerData(int color, int luminosity, boolean noTint) {
            this.color = color;
            this.luminosity = luminosity;
            this.noTint = noTint;
        }

        public int getColor() {
            return this.color;
        }

        public int getLuminosity() {
            return this.luminosity;
        }

        public boolean isNoTint() {
            return this.noTint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LayerData)) {
                return false;
            }
            LayerData other = (LayerData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getColor() != other.getColor()) {
                return false;
            }
            if (this.getLuminosity() != other.getLuminosity()) {
                return false;
            }
            return this.isNoTint() == other.isNoTint();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LayerData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColor();
            result = result * 59 + this.getLuminosity();
            result = result * 59 + (this.isNoTint() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "MantleItemLayerModel.LayerData(color=" + this.getColor() + ", luminosity=" + this.getLuminosity() + ", noTint=" + this.isNoTint() + ")";
        }
    }

    private static class FaceData {
        private final EnumMap<Direction, BitSet> data = new EnumMap(Direction.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(Direction.WEST, new BitSet(uMax * vMax));
            this.data.put(Direction.EAST, new BitSet(uMax * vMax));
            this.data.put(Direction.UP, new BitSet(uMax * vMax));
            this.data.put(Direction.DOWN, new BitSet(uMax * vMax));
        }

        public void set(Direction facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(Direction facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }
}

