/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;

public class ColoredBlockModel
implements IModelGeometry<ColoredBlockModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final List<ColorData> colorData;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IModelConfiguration owner, BlockPart part, int color, int luminosity, IModelTransform transform, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        for (Direction direction : part.field_178240_c.keySet()) {
            BlockPartFace face = (BlockPartFace)part.field_178240_c.get(direction);
            String texture = face.field_178242_d;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(texture));
            BakedQuad quad = ColoredBlockModel.bakeFace(part, face, sprite, direction, transform, color, luminosity, location);
            if (face.field_178244_b == null) {
                builder.func_177648_a(quad);
                continue;
            }
            builder.func_177650_a(Direction.func_229385_a_((Matrix4f)transform.func_225615_b_().func_227988_c_(), (Direction)face.field_178244_b), quad);
        }
    }

    public static IBakedModel bakeModel(IModelConfiguration owner, List<BlockPart> elements, List<ColorData> colorData, IModelTransform transform, ItemOverrideList overrides, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(owner, overrides).func_177646_a(particle);
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            BlockPart part = elements.get(i);
            ColorData colors = LogicHelper.getOrDefault(colorData, i, ColorData.DEFAULT);
            ColoredBlockModel.bakePart(builder, owner, part, colors.getColor(), colors.getLuminosity(), transform, spriteGetter, location);
        }
        return builder.func_177645_b();
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        return ColoredBlockModel.bakeModel(owner, this.model.getElements(), this.colorData, modelTransform, overrides, spriteGetter, modelLocation);
    }

    public static BakedQuad bakeFace(BlockPart part, BlockPartFace face, TextureAtlasSprite sprite, Direction facing, IModelTransform transform, int color, int luminosity, ResourceLocation location) {
        return ColoredBlockModel.bakeQuad(part.field_178241_a, part.field_178239_b, face, sprite, facing, transform, part.field_178237_d, part.field_178238_e, color, luminosity, location);
    }

    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockPartFace face, TextureAtlasSprite sprite, Direction facing, IModelTransform transform, @Nullable BlockPartRotation partRotation, boolean shade, int color, int luminosity, ResourceLocation location) {
        BlockFaceUV faceUV = face.field_178243_e;
        if (transform.func_188049_c()) {
            faceUV = FaceBakery.func_228821_a_((BlockFaceUV)face.field_178243_e, (Direction)facing, (TransformationMatrix)transform.func_225615_b_(), (ResourceLocation)location);
        }
        float[] originalUV = new float[faceUV.field_178351_a.length];
        System.arraycopy(faceUV.field_178351_a, 0, originalUV, 0, originalUV.length);
        float shrinkRatio = sprite.func_229242_p_();
        float u = (faceUV.field_178351_a[0] + faceUV.field_178351_a[0] + faceUV.field_178351_a[2] + faceUV.field_178351_a[2]) / 4.0f;
        float v = (faceUV.field_178351_a[1] + faceUV.field_178351_a[1] + faceUV.field_178351_a[3] + faceUV.field_178351_a[3]) / 4.0f;
        faceUV.field_178351_a[0] = MathHelper.func_219799_g((float)shrinkRatio, (float)faceUV.field_178351_a[0], (float)u);
        faceUV.field_178351_a[2] = MathHelper.func_219799_g((float)shrinkRatio, (float)faceUV.field_178351_a[2], (float)u);
        faceUV.field_178351_a[1] = MathHelper.func_219799_g((float)shrinkRatio, (float)faceUV.field_178351_a[1], (float)v);
        faceUV.field_178351_a[3] = MathHelper.func_219799_g((float)shrinkRatio, (float)faceUV.field_178351_a[3], (float)v);
        int[] vertexData = ColoredBlockModel.makeQuadVertexData(faceUV, sprite, facing, BlockModel.field_217647_g.func_199337_a(posFrom, posTo), transform.func_225615_b_(), partRotation, color, luminosity);
        Direction direction = FaceBakery.func_178410_a((int[])vertexData);
        System.arraycopy(originalUV, 0, faceUV.field_178351_a, 0, originalUV.length);
        if (partRotation == null) {
            BlockModel.field_217647_g.func_178408_a(vertexData, direction);
        }
        ForgeHooksClient.fillNormal((int[])vertexData, (Direction)direction);
        return new BakedQuad(vertexData, face.field_178245_c, direction, sprite, shade);
    }

    private static int[] makeQuadVertexData(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, TransformationMatrix rotationIn, @Nullable BlockPartRotation partRotation, int color, int luminosity) {
        int[] vertexData = new int[32];
        for (int i = 0; i < 4; ++i) {
            ColoredBlockModel.fillVertexData(vertexData, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, color, luminosity);
        }
        return vertexData;
    }

    private static void fillVertexData(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, TransformationMatrix rotationIn, @Nullable BlockPartRotation partRotation, int color, int luminosity) {
        FaceDirection.VertexInformation vertexInfo = FaceDirection.func_179027_a((Direction)facing).func_179025_a(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[vertexInfo.field_179184_a], posDiv16[vertexInfo.field_179182_b], posDiv16[vertexInfo.field_179183_c]);
        BlockModel.field_217647_g.func_199336_a(vector3f, partRotation);
        BlockModel.field_217647_g.func_228822_a_(vector3f, rotationIn);
        ColoredBlockModel.fillVertexData(vertexData, vertexIndex, vector3f, sprite, blockFaceUVIn, color, luminosity);
    }

    private static int swapColorRedBlue(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000;
    }

    private static void fillVertexData(int[] vertexData, int vertexIndex, Vector3f vector, TextureAtlasSprite sprite, BlockFaceUV blockFaceUV, int color, int luminosity) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.func_195899_a());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.func_195900_b());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.func_195902_c());
        vertexData[i + 3] = ColoredBlockModel.swapColorRedBlue(color);
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)blockFaceUV.func_178348_a(vertexIndex) * 0.999 + (double)blockFaceUV.func_178348_a((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 5] = Float.floatToRawIntBits(sprite.func_94207_b((double)blockFaceUV.func_178346_b(vertexIndex) * 0.999 + (double)blockFaceUV.func_178346_b((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 6] = luminosity << 4;
    }

    public ColoredBlockModel(SimpleBlockModel model, List<ColorData> colorData) {
        this.model = model;
        this.colorData = colorData;
    }

    private static class Loader
    implements IModelLoader<ColoredBlockModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ColoredBlockModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(deserializationContext, modelContents);
            List<ColorData> colorData = JsonHelper.parseList(modelContents, "colors", ColorData::fromJson);
            return new ColoredBlockModel(model, colorData);
        }
    }

    public static class ColorData {
        public static final ColorData DEFAULT = new ColorData(-1, -1);
        private final int color;
        private final int luminosity;

        public static ColorData fromJson(JsonObject json) {
            int color = JsonHelper.parseColor(JSONUtils.func_151219_a((JsonObject)json, (String)"color", (String)""));
            int luminosity = JSONUtils.func_151208_a((JsonObject)json, (String)"luminosity", (int)0);
            return new ColorData(color, luminosity);
        }

        public ColorData(int color, int luminosity) {
            this.color = color;
            this.luminosity = luminosity;
        }

        public int getColor() {
            return this.color;
        }

        public int getLuminosity() {
            return this.luminosity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColorData)) {
                return false;
            }
            ColorData other = (ColorData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getColor() != other.getColor()) {
                return false;
            }
            return this.getLuminosity() == other.getLuminosity();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColorData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColor();
            result = result * 59 + this.getLuminosity();
            return result;
        }

        public String toString() {
            return "ColoredBlockModel.ColorData(color=" + this.getColor() + ", luminosity=" + this.getLuminosity() + ")";
        }
    }
}

