/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;

public class FaucetFluidLoader
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final FaucetFluidLoader INSTANCE = new FaucetFluidLoader();
    private static final ResourceLocation DEFAULT_NAME = Mantle.getResource("_default");
    private final Map<BlockState, FaucetFluid> fluidMap = new HashMap<BlockState, FaucetFluid>();
    private static boolean initialized = false;
    private FaucetFluid defaultFluid = FaucetFluid.access$000();

    public static void initialize() {
        IResourceManager manager;
        if (initialized) {
            return;
        }
        initialized = true;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && (manager = mc.func_195551_G()) instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)INSTANCE);
        }
    }

    private FaucetFluidLoader() {
        super(GSON, "models/faucet_fluid");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, IResourceManager resourceManager, IProfiler profiler) {
        JsonElement def = map.get(DEFAULT_NAME);
        if (def == null || !def.isJsonObject()) {
            Mantle.logger.warn("Found no default fluid model, this is likely a problem with the resource pack");
            this.defaultFluid = FaucetFluid.EMPTY;
        } else {
            try {
                this.defaultFluid = FaucetFluid.parseDefault(def.getAsJsonObject());
            }
            catch (Exception exception) {
                Mantle.logger.error("Failed to load default faucet fluid model {}", (Object)DEFAULT_NAME, (Object)exception);
            }
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.equals((Object)DEFAULT_NAME) || !entry.getValue().isJsonObject()) continue;
            try {
                JsonObject json = JSONUtils.func_151210_l((JsonElement)entry.getValue(), (String)"");
                JsonObject variants = JSONUtils.func_152754_s((JsonObject)json, (String)"variants");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
                if (block != null && block != Blocks.field_150350_a) {
                    StateContainer container = block.func_176194_O();
                    ImmutableList validStates = container.func_177619_a();
                    for (Map.Entry variant : variants.entrySet()) {
                        FaucetFluid fluid = FaucetFluid.fromJson(JSONUtils.func_151210_l((JsonElement)((JsonElement)variant.getValue()), (String)((String)variant.getKey())), this.defaultFluid);
                        validStates.stream().filter(ModelBakery.func_209605_a((StateContainer)container, (String)((String)variant.getKey()))).forEach(state -> this.fluidMap.put((BlockState)state, fluid));
                    }
                    continue;
                }
                Mantle.logger.debug("Skipping loading faucet fluid model '{}' as no coorsponding block exists", (Object)location);
            }
            catch (Exception e) {
                Mantle.logger.warn("Exception loading faucet fluid model '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    public static FaucetFluid get(BlockState state) {
        return FaucetFluidLoader.INSTANCE.fluidMap.getOrDefault(state, FaucetFluidLoader.INSTANCE.defaultFluid);
    }

    public static void renderFaucetFluids(IWorld world, BlockPos pos, Direction direction, MatrixStack matrices, IVertexBuilder buffer, TextureAtlasSprite still, TextureAtlasSprite flowing, int color, int light) {
        FaucetFluid faucetFluid;
        int i = 0;
        do {
            faucetFluid = FaucetFluidLoader.get(world.func_180495_p(pos.func_177979_c(++i)));
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, (double)(-i), 0.0);
            for (FluidCuboid cube : faucetFluid.getFluids(direction)) {
                FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, false);
            }
            matrices.func_227865_b_();
        } while (faucetFluid.isContinued());
    }

    public static class FaucetFluid {
        private static final FaucetFluid EMPTY = new FaucetFluid(Collections.emptyList(), Collections.emptyList(), false);
        private final List<FluidCuboid> side;
        private final List<FluidCuboid> center;
        private final boolean cont;

        public FaucetFluid(List<FluidCuboid> side, List<FluidCuboid> center, boolean cont) {
            this.side = side;
            this.center = center;
            this.cont = cont;
        }

        public List<FluidCuboid> getFluids(Direction dir) {
            if (dir.func_176740_k() == Direction.Axis.Y) {
                return this.center;
            }
            return this.side;
        }

        public boolean isContinued() {
            return this.cont;
        }

        protected static FaucetFluid parseDefault(JsonObject json) {
            List<FluidCuboid> side = FluidCuboid.listFromJson(json, "side");
            List<FluidCuboid> center = FluidCuboid.listFromJson(json, "center");
            return new FaucetFluid(side, center, false);
        }

        protected static FaucetFluid fromJson(JsonObject json, FaucetFluid def) {
            List<FluidCuboid> side = FaucetFluid.parseFluids(json, "side", def.side);
            List<FluidCuboid> center = FaucetFluid.parseFluids(json, "center", def.center);
            boolean cont = JSONUtils.func_151209_a((JsonObject)json, (String)"continue", (boolean)false);
            return new FaucetFluid(side, center, cont);
        }

        private static List<FluidCuboid> parseFluids(JsonObject json, String tag, List<FluidCuboid> def) {
            JsonElement element;
            if (json.has(tag)) {
                element = json.get(tag);
            } else if (json.has("bottom") && json.get("bottom").isJsonPrimitive()) {
                element = json.get("bottom");
            } else {
                return def;
            }
            if (element.isJsonPrimitive()) {
                int value = element.getAsInt();
                return def.stream().map(cuboid -> {
                    Vector3f from = cuboid.getFrom().func_229195_e_();
                    from.setY((float)value);
                    return new FluidCuboid(from, cuboid.getTo(), cuboid.getFaces());
                }).collect(Collectors.toList());
            }
            return FluidCuboid.listFromJson(json, tag);
        }
    }
}

