/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.action.protocol.ProtocolGoToPage;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.ContentBlank;
import slimeknights.mantle.client.book.data.content.ContentBlockInteraction;
import slimeknights.mantle.client.book.data.content.ContentCrafting;
import slimeknights.mantle.client.book.data.content.ContentImage;
import slimeknights.mantle.client.book.data.content.ContentImageText;
import slimeknights.mantle.client.book.data.content.ContentIndex;
import slimeknights.mantle.client.book.data.content.ContentPadding;
import slimeknights.mantle.client.book.data.content.ContentShowcase;
import slimeknights.mantle.client.book.data.content.ContentSmelting;
import slimeknights.mantle.client.book.data.content.ContentSmithing;
import slimeknights.mantle.client.book.data.content.ContentStructure;
import slimeknights.mantle.client.book.data.content.ContentText;
import slimeknights.mantle.client.book.data.content.ContentTextImage;
import slimeknights.mantle.client.book.data.content.ContentTextLeftImage;
import slimeknights.mantle.client.book.data.content.ContentTextRightImage;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.deserializer.HexStringDeserializer;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.network.packet.UpdateHeldPagePacket;
import slimeknights.mantle.network.packet.UpdateLecternPagePacket;

@OnlyIn(value=Dist.CLIENT)
public class BookLoader
implements ISelectiveResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(Integer.TYPE, (Object)new HexStringDeserializer()).create();
    private static final HashMap<String, Class<? extends PageContent>> typeToContentMap = new HashMap();
    private static final HashMap<String, BookData> books = new HashMap();

    public BookLoader() {
        BookLoader.registerPageType("blank", ContentBlank.class);
        BookLoader.registerPageType("text", ContentText.class);
        BookLoader.registerPageType("left_padding", ContentPadding.ContentLeftPadding.class);
        BookLoader.registerPageType("right_padding", ContentPadding.ContentRightPadding.class);
        BookLoader.registerPageType("image", ContentImage.class);
        BookLoader.registerPageType("image with text below", ContentImageText.class);
        BookLoader.registerPageType("text with image below", ContentTextImage.class);
        BookLoader.registerPageType("text with left image etch", ContentTextLeftImage.class);
        BookLoader.registerPageType("text with right image etch", ContentTextRightImage.class);
        BookLoader.registerPageType("crafting", ContentCrafting.class);
        BookLoader.registerPageType("smelting", ContentSmelting.class);
        BookLoader.registerPageType("smithing", ContentSmithing.class);
        BookLoader.registerPageType("block interaction", ContentBlockInteraction.class);
        BookLoader.registerPageType("structure", ContentStructure.class);
        BookLoader.registerPageType("index", ContentIndex.class);
        BookLoader.registerPageType("showcase", ContentShowcase.class);
        StringActionProcessor.registerProtocol(new ProtocolGoToPage());
        StringActionProcessor.registerProtocol(new ProtocolGoToPage(true, "go-to-page-rtn"));
    }

    public static void registerPageType(String name, Class<? extends PageContent> clazz) {
        if (typeToContentMap.containsKey(name)) {
            throw new IllegalArgumentException("Page type " + name + " already in use.");
        }
        typeToContentMap.put(name, clazz);
    }

    @Nullable
    public static Class<? extends PageContent> getPageType(String name) {
        return typeToContentMap.get(name);
    }

    public static BookData registerBook(String name, BookRepository ... repositories) {
        return BookLoader.registerBook(name, true, true, repositories);
    }

    public static BookData registerBook(String name, boolean appendIndex, boolean appendContentTable, BookRepository ... repositories) {
        BookData info = new BookData(repositories);
        books.put(name.contains(":") ? name : ModLoadingContext.get().getActiveContainer().getNamespace() + ":" + name, info);
        if (appendIndex) {
            info.addTransformer(BookTransformer.indexTranformer());
        }
        if (appendContentTable) {
            info.addTransformer(BookTransformer.contentTableTransformer());
        }
        return info;
    }

    public static void updateSavedPage(@Nullable PlayerEntity player, Hand hand, String page) {
        ItemStack item;
        if (player != null && !(item = player.func_184586_b(hand)).func_190926_b()) {
            BookHelper.writeSavedPageToBook(item, page);
            MantleNetwork.INSTANCE.network.sendToServer((Object)new UpdateHeldPagePacket(hand, page));
        }
    }

    public static void updateSavedPage(BlockPos pos, String page) {
        MantleNetwork.INSTANCE.network.sendToServer((Object)new UpdateLecternPagePacket(pos, page));
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        books.forEach((s, bookData) -> bookData.reset());
    }
}

